'use strict';

// Allows the release header to be customized according to the current location
angular.module('xlrelease').controller('releaseHeaderController', ['$scope', '$location', function ($scope, $location) {
    var editor      = 'EDITOR',
        summary     = 'SUMMARY',
        properties  = 'PROPERTIES',
        teams       = 'TEAMS',
        permissions = 'PERMISSIONS',
        logs        = 'LOGS';

    var notDefaultPages = [summary, properties, teams, permissions, logs];

    $scope.page = _.find(notDefaultPages, function (aPage) {
        var regexp = new RegExp(aPage + '$', 'i');
        return $location.path().match(regexp);  // if current location ends with one of the subpages
    });

    $scope.page = $scope.page || editor;

    $scope.isEditorPage = function () {
        return isPage(editor);
    };

    $scope.isSummaryPage = function () {
        return isPage(summary);
    };

    $scope.isPropertiesPage = function () {
        return isPage(properties);
    };

    $scope.isTeamsPage = function () {
        return isPage(teams);
    };

    $scope.isPermissionsPage = function () {
        return isPage(permissions);
    };

    $scope.isLogsPage = function () {
        return isPage(logs);
    };

    function isPage(page) {
        return $scope.page === page;
    }
}]);
