'use strict';

angular.module('xlrelease').controller('releasePropertiesController', ['$scope', '$location', 'Backend', 'Authenticator', 'ReleasesService', '$routeParams', '$window', 'FlagService', 'VariablesService', 'DeployitService', function ($scope, $location, Backend, Authenticator, ReleasesService, $routeParams, $window, FlagService, VariablesService, DeployitService) {
    var DEFAULT_START_HOUR = 9;
    var DEFAULT_DUE_HOUR = 17;

    var ICS_ENDPOINT = 'calendar/subscribe/';

    var defaultNewReleaseForm = {
        owner: Authenticator.getUsername(),
        scheduledStartDate: moment().hours(DEFAULT_START_HOUR).minutes(0).toDate(),
        dueDate: moment().hours(DEFAULT_DUE_HOUR).minutes(0).toDate(),
        newRelease: true,
        tags: [],
        variables: [],
        flag: {
            status: FlagService.NOT_FLAGGED_STATUS
        }
    };

    Backend.get('users').success(function (allUserNames) {
        $scope.allUserNames = allUserNames;
    });

    $scope.initCalendarURL = function (release) {
        Backend.get('server/host').success(function (host) {
            if (!host.match(/\/$/)) {
                host += '/';
            }

            $scope.calendarUrl = host + ICS_ENDPOINT + release.calendarLinkToken;
        });
    };

    $scope.initReleaseForm = function () {
        clearForm();

        // Query the backend to recompute the variables (some might have been added by updating tasks or phases on the
        // release page)
        Backend.get('releases/' + $routeParams.releaseId).success(function (release) {
            $scope.release = release;
            var variables = VariablesService.collectUsedVariables(release.variables);
            initDeployitCompletion(variables);

            $scope.initCalendarURL(release);

            release.variables = variables;
            $scope.releaseForm = {
                id: release.id,
                title: release.title,
                scheduledStartDate: release.scheduledStartDate,
                dueDate: release.dueDate,
                description: release.description,
                owner: release.owner,
                variables: angular.copy(release.variables),
                readonly: ReleasesService.isReleaseCompleted(release) || !Authenticator.hasEditPermission(release),
                tags: release.tags,
                flag: release.releaseFlag,
                calendarLinkToken: release.calendarLinkToken,
                calendarPublished: release.calendarPublished
            };
        });
    };

    $scope.initNewReleaseForm = function () {
        var templateId = $routeParams.fromTemplateId;

        Backend.get('releases/templates').success(function (templates) {
            $scope.templates = templates;

            if (templateId) {
                $scope.updateFormWithTemplate(templateId);
            } else {
                $scope.updateFormWithoutTemplate();
            }
        });
    };

    $scope.updateFormWithTemplate = function (templateId) {
        if (!templateId) {
            $scope.updateFormWithoutTemplate();
        } else {
            var fromTemplate = _.find($scope.templates, function (template) {
                return template.id === templateId;
            });

            var variables = VariablesService.collectUsedVariables(fromTemplate.variables);
            initDeployitCompletion(variables);

            $scope.releaseForm = angular.copy(defaultNewReleaseForm);
            $scope.releaseForm = angular.extend($scope.releaseForm, {
                templateId: templateId,
                description: fromTemplate.description,
                newRelease: true,
                variables: variables,
                tags: fromTemplate.tags
            });
        }
    };

    $scope.updateFormWithoutTemplate = function () {
        $scope.releaseForm = defaultNewReleaseForm;
    };

    if ($location.path().match('create$')) {
        $scope.initNewReleaseForm();
    } else {
        $scope.initReleaseForm();
    }

    $scope.$watch('releaseForm.dueDate + releaseForm.scheduledStartDate', function () {
        if ($scope.releaseForm) {
            var dueDate = $scope.releaseForm.dueDate;
            var scheduledStartDate = $scope.releaseForm.scheduledStartDate;

            if (angular.isDefined(dueDate) && angular.isDefined(scheduledStartDate)) {
                $scope.releaseForm.hasValidDates = scheduledStartDate <= dueDate;
            }
        }
    });

    function clearForm() {
        delete $scope.releaseForm;
        delete $scope.releaseUpdatedAt;
    }

    function initDeployitCompletion(variables) {
        $scope.deployitPackages = [];
        $scope.deployitEnvironments = [];
        DeployitService.getAllEnvironmentsAndPackages(variables, function (packages) {
            $scope.deployitPackages = packages;
        }, function (environments) {
            $scope.deployitEnvironments = environments;
        });
    }

    $scope.releasePropertiesUpdated = function () {
        var release = {
            title: $scope.releaseForm.title,
            description: $scope.releaseForm.description,
            owner: $scope.releaseForm.owner,
            scheduledStartDate: $scope.releaseForm.scheduledStartDate,
            dueDate: $scope.releaseForm.dueDate,
            variables: $scope.releaseForm.variables,
            tags: $scope.releaseForm.tags,
            flag: $scope.releaseForm.flag,
            calendarPublished: $scope.releaseForm.calendarPublished
        };
        if ($scope.releaseForm.newRelease) {
            release.templateId = $scope.releaseForm.templateId;
            $scope.creationInProgress = true;
            Backend.post('releases', release).success(function (releaseView) {
                $scope.creationInProgress = false;
                $location.path('/releases/' + releaseView.id);
            });
        } else {
            Backend.put('releases/' + $scope.releaseForm.id, release).success(function () {
                $scope.release.title = $scope.releaseForm.title;
                $scope.releaseUpdatedAt = moment().toDate();
            });
        }
    };

    $scope.back = function () {
        $window.history.back();
    };
    
    $scope.flag = function (flag) {
        $scope.releaseForm.flag.status = flag;
        if (!FlagService.isItemFlagged($scope.releaseForm)) {
            $scope.releaseForm.flag.comment = '';
        }
    };

    $scope.downloadCalendar = ReleasesService.downloadCalendar;
}]);
