'use strict';

angular.module('xlrelease').controller('releasesController', ['$scope', 'Timeout', 'Backend', 'ReleasesService', 'TasksService', '$location', 'FlagService', 'DateService', function ($scope, Timeout, Backend, ReleasesService, TasksService, $location, FlagService, DateService) {
    function loadReleases() {
        $scope.$emit('REFRESH_PERMISSIONS');
        Backend.get('releases', { params: $scope.filters }).success(function (releases) {
            $scope.releases = releases;
        });
    }

    $scope.delayedWatch(500, 'searchFilter', function (newFilter) {
        $scope.filters.filter = newFilter;
    });

    $scope.filters = {
        active: true,
        planned: true,
        completed: false,
        onlyMine: false,
        onlyFlagged: false,
        filter: ''
    };

    $scope.$watchCollection('filters', loadReleases);

    $scope.startRelease = function (release) {
        ReleasesService.startRelease(release).success(loadReleases);
    };

    $scope.abortRelease = function (release) {
        ReleasesService.abortRelease(release).success(loadReleases);
    };

    $scope.isReleaseCompleted = ReleasesService.isReleaseCompleted;
    $scope.isReleasePlanned = ReleasesService.isReleasePlanned;
    $scope.isReleaseFailed = ReleasesService.isReleaseFailed;
    $scope.isReleaseFailing = ReleasesService.isReleaseFailing;
    $scope.isReleasePaused = ReleasesService.isReleasePaused;
    $scope.isReleaseInProgress = ReleasesService.isReleaseInProgress;
    $scope.isReleaseAborted = ReleasesService.isReleaseAborted;
    $scope.isReleaseOrSubtaskFlagged = FlagService.isReleaseOrSubtaskFlagged;
    $scope.isTaskPending = TasksService.isTaskPending;
    $scope.isTaskFailed = TasksService.isTaskFailed;
    $scope.isTaskFlagged = FlagService.isTaskFlagged;
    $scope.isOverdue = DateService.isOverdue;

    $scope.shouldDisplaySubTask = function (task) {
        return TasksService.isTaskPending(task) || TasksService.isTaskInProgress(task);
    };

    $scope.displayReleaseEditor = function (release) {
        $location.path('/releases/' + release.id);
    };

    $scope.hasAutomatedTaskInProgress = function (release) {
        return _.some(release.currentSimpleTasks, function (task) {
            return TasksService.isTaskInProgress(task) && TasksService.isAutomated(task);
        });
    };
}]);
