angular.module('xlrelease').directive('phaseSortable', function () {
    var isPhaseBeingSorted = function (event) {
        return $(event.target).is("#release-content");
    };

    return function (scope, element) {
        scope.$watch('release', function (releaseIsAvailable, oldRelease) {
            if (angular.isDefined(releaseIsAvailable) && angular.isUndefined(oldRelease)) {
                scope.$evalAsync(function () {
                    element.sortable({
                        items: '.phase:not(.sort-disabled)',
                        handle: '.phase-sort-handle',
                        cursor: "move",
                        axis: "x",
                        tolerance: "pointer",
                        forcePlaceholderSize: true,
                        opacity: 0.7,
                        placeholder: 'phase-drop-placeholder'
                    });
                });

                element.on('sortstart', function(event, ui) {
                    if (isPhaseBeingSorted(event)) {
                        ui.item.fromIndex = ui.item.index();
                    }
                });
                
                element.on('sortupdate', function(event, ui) {
                    if (isPhaseBeingSorted(event)) {
                        var fromIndex = ui.item.fromIndex;
                        var toIndex = ui.item.index();

                        scope.$apply(function() {
                            scope.movePhase(fromIndex, toIndex);
                        });
                    }
                });
            }
        });
    };
});

angular.module('xlrelease').directive('taskSortable', function () {
    function isTaskBeingSorted(event) {
        return $(event.target).is(".task-sortable");
    }

    function isOriginalPhaseUpdated(ui) {
        return ui.sender === null;
    }

    function getTaskOrPhase(scope) {
        return scope['task'] || scope['phase'];
    }

    return function (scope, element) {
        element.sortable({
            items: '.item-sortable:not(.sort-disabled)',
            connectWith: '.phase .task-sortable:not(.sort-disabled)',
            handle: '.task-sort-handle',
            cursor: 'move',
            tolerance: 'intersect',
            placeholder: 'task-drop-placeholder',
            forcePlaceholderSize: true
        });

        element.on('sortstart', function (event, ui) {
            if (isTaskBeingSorted(event)) {
                event.stopImmediatePropagation();

                ui.item.fromTaskOrPhase = getTaskOrPhase($(event.target).scope());
                ui.item.fromIndex = ui.item.index();
            }
        });

        element.on('sortupdate', function(event, ui) {
            if (isTaskBeingSorted(event) && isOriginalPhaseUpdated(ui)) {
                event.stopImmediatePropagation();

                var fromTaskOrPhase = ui.item.fromTaskOrPhase;
                var fromIndex = ui.item.fromIndex;
                var toTaskOrPhase = getTaskOrPhase(ui.item.parent('.task-sortable').scope());
                var toIndex = ui.item.index();

                scope.$apply(function() {
                    scope.moveTask(fromTaskOrPhase, fromIndex, toTaskOrPhase, toIndex);
                });
            }
        });
    };
});
