'use strict';

angular.module('xlrelease').controller('teamsController', ['$scope', '$routeParams', 'Backend', function ($scope, $routeParams, Backend) {
    var DEFAULT_TEAM_NAME = "New team";

    Backend.get('teams/release/' + $routeParams.releaseId).success(function (teams) {
        $scope.teams = teams;
    });

    Backend.get('releases/' + $routeParams.releaseId).success(function (release) {
        $scope.release = release;
    });

    Backend.get('users').success(function (allUserNames) {
        $scope.allUserNames = allUserNames;
    });

    $scope.addTeam = function () {
        var newTeam = {teamName: DEFAULT_TEAM_NAME, members: []};
        Backend.post('teams/release/' + $routeParams.releaseId, newTeam).success(function (team) {
            $scope.teams.push(team);
        });
    };

    $scope.deleteTeam = function (teamToDelete) {
        Backend.del('teams/' + teamToDelete.id).success(function () {
            $scope.teams = _.filter($scope.teams, function (team) {
                return team.id !== teamToDelete.id;
            });
        });
    };

    $scope.saveTeam = function (team, members) {
        team.members = members;
        Backend.put('teams/' + team.id, team);
    };
}]);
