'use strict';

angular.module('xlrelease').controller('reportController', ['$scope', 'Backend', function ($scope, Backend) {
    $scope.getReportsSince = function(timeFrame) {
        Backend.get('reports/releases/duration?since=' + timeFrame).success(function (releasesDuration) {
            if (releasesDuration['AVERAGE'].length) {
                $scope.releasesDuration = releasesDuration;
            }
        });
        Backend.get('reports/releases/automation?since=' + timeFrame).success(function (releasesAutomation) {
            if (releasesAutomation['AVERAGE_AUTOMATION_PERCENTAGE'].length) {
                $scope.releasesAutomation = releasesAutomation;
            }
        });
        Backend.get('reports/most-involved-people?since=' + timeFrame).success(function (mostInvolvedPeople) {
            if (mostInvolvedPeople.length) {
                $scope.mostInvolvedPeople = mostInvolvedPeople;
            }
        });
        Backend.get('reports/longest-tasks?since=' + timeFrame).success(function (longestTasks) {
            if (longestTasks.length) {
                $scope.longestTasks = longestTasks;
            }
        });
        Backend.get('reports/longest-phases?since=' + timeFrame).success(function (longestPhases) {
            if (longestPhases.length) {
                $scope.longestPhases = longestPhases;
            }
        });
        Backend.get('reports/releases/number-by-month?since=' + timeFrame).success(function (numberOfReleasesPerMonth) {
            if (numberOfReleasesPerMonth.length) {
                $scope.numberOfReleasesPerMonth = numberOfReleasesPerMonth;
            }
        });
    };

    $scope.getReportsSince('LAST_SIX_MONTHS');
}]);
