'use strict';


angular.module('xlrelease').controller('permissionsController', ['$scope', 'Backend', '$routeParams', function ($scope, Backend, $routeParams) {
    function getPermissionEndpoint() {
        if ($scope.inReleaseContext) {
            return "releases/" + $routeParams.releaseId + "/permissions";
        }
        return "roles/permissions/global";
    }

    function loadPermissions() {
        if (angular.isDefined($routeParams.releaseId)) {
            $scope.inReleaseContext = true;
            Backend.get('releases/' + $routeParams.releaseId).success(function (release) {
                $scope.release = release;
            });
            Backend.get(getPermissionEndpoint()).success(function (releasePermissionsView) {
                $scope.permissionsContainers = releasePermissionsView.teams;
                $scope.permissions = releasePermissionsView.permissions;
                delete $scope.dirty;
            });
        } else {
            Backend.get(getPermissionEndpoint()).success(function (rolePermissionsView) {
                $scope.permissionsContainers = rolePermissionsView.rolePermissions;
                $scope.permissions = rolePermissionsView.permissions;
                delete $scope.dirty;
            });
        }
    }

    loadPermissions();

    $scope.getClass = function (permissionName) {
        return "permission-" + permissionName.replace("#", "_");
    };

    $scope.hasPermission = function (permissions, expected) {
        return _.contains(permissions, expected);
    };

    $scope.togglePermission = function (permissionsContainer, permission) {
        if ($scope.hasPermission(permissionsContainer.permissions, permission)) {
            permissionsContainer.permissions = _.without(permissionsContainer.permissions, permission);
        } else {
            permissionsContainer.permissions.push(permission);
        }
        $scope.setDirty();
    };

    $scope.save = function () {
        Backend.put(getPermissionEndpoint(), $scope.permissionsContainers).success(function () {
            $scope.lastSavedDate = moment().toDate();
            delete $scope.dirty;
        });
    };

    $scope.reset = function () {
        loadPermissions();
        delete $scope.lastSavedDate;
        delete $scope.dirty;
    };

    $scope.getRoleOrTeamName = function (permissionsContainer) {
        if ($scope.inReleaseContext) {
            return permissionsContainer.teamName;
        } else {
            return permissionsContainer.role.name;
        }
    };

    $scope.setDirty = function() {
        $scope.dirty = true;
    };
}]);
