'use strict';

angular.module('xlrelease').controller('rolesController', ['$scope', 'Backend', function ($scope, Backend) {
    function loadRolePrincipalsList() {
        Backend.get('internal/security/roles/principals').success(function (rolePrincipalsList) {
            $scope.rolePrincipalsList = rolePrincipalsList;
        });
    }

    loadRolePrincipalsList();

    Backend.get('users').success(function (allUserNames) {
        $scope.allUserNames = allUserNames;
    });

    $scope.addRole = function () {
        $scope.rolePrincipalsList.push({role: {name: "new role"}, principals: []});
        $scope.setDirty();
    };

    $scope.deleteRole = function (rolePrincipals) {
        $scope.rolePrincipalsList = _.without($scope.rolePrincipalsList, rolePrincipals);
        $scope.setDirty();
    };

    $scope.save = function () {
        Backend.post('internal/security/roles/principals', $scope.rolePrincipalsList).success(function () {
            $scope.lastSavedDate = moment().toDate();
            delete $scope.dirty;
        });
    };

    $scope.reset = function () {
        loadRolePrincipalsList();
        delete $scope.lastSavedDate;
        delete $scope.dirty;
    };

    $scope.setDirty = function() {
        $scope.dirty = true;
    };
}]);
