'use strict';

angular.module('xlrelease').controller('smtpController', ['$scope', 'Backend', 'Alerts', function ($scope, Backend, Alerts) {
    var MAIL_DIRECTORY = 'repository/ci/Configuration/mail';
    var SMTP_SERVER_URL = MAIL_DIRECTORY + '/SmtpServer';

    var smtpServerExists;

    Backend.get('metadata/type/xlrelease.SmtpServer').success(function (type) {
        $scope.type = type;
    });

    Backend.get(SMTP_SERVER_URL).success(function (ci) {
        $scope.smtpServer = ci;
        smtpServerExists = true;
    }).error(function (data, status) {
        if (status === 404) {
            Alerts.clearError();
        }
        $scope.smtpServer = {};
    });

    $scope.save = function () {
        if (smtpServerExists) {
            Backend.put(SMTP_SERVER_URL, $scope.smtpServer).success(itemSaved);
        } else {
            $scope.smtpServer.type = 'xlrelease.SmtpServer';
            $scope.smtpServer.id = 'Configuration/mail/SmtpServer';

            Backend.post(MAIL_DIRECTORY, {type: 'core.Directory', id: 'Configuration/mail'}).success(function () {
                Backend.post(SMTP_SERVER_URL, $scope.smtpServer).success(itemSaved);
            });
        }
    };

    function itemSaved() {
        smtpServerExists = true;
        $scope.lastSavedDate = moment().toDate();
    }
}]);
