'use strict';

angular.module('xlrelease').controller('gateDetailsController', ['$scope', 'Backend', 'TasksService', 'Authenticator', 'VariablesInterpolator', function ($scope, Backend, TasksService, Authenticator, VariablesInterpolator) {
    var CONDITIONS_URL = 'gates/conditions/';

    Backend.get('gates/' + $scope.task.id + '/dependency-target-candidates').success(function (dependencyTargetCandidates) {
        $scope.dependencyTargetCandidates = dependencyTargetCandidates;
    });

    $scope.addCondition = function () {
        Backend.post('gates/' +  $scope.task.id + '/conditions/add').success(function (condition) {
            $scope.task.conditions.push(condition);
        });
    };

    $scope.updateCondition = function (condition) {
        Backend.put(CONDITIONS_URL + condition.id, condition).success(function () {
            if (!TasksService.isGateClosed($scope.task)) {
                $scope.completeTaskMode = true;
            }
        })
    };

    $scope.removeCondition = function (removedCondition) {
        Backend.del(CONDITIONS_URL + removedCondition.id).success(function () {
            $scope.task.conditions = _.reject($scope.task.conditions, function (condition) {
                return removedCondition === condition;
            });
        })
    };

    $scope.addDependency = function () {
        var dependency = {
            target: {
                releaseId: $scope.dependencyTargetCandidates[0].id
            }
        };
        $scope.task.dependencies.push(dependency);
        $scope.editDependency(dependency);
    };

    $scope.updateReleaseDropdown = function (dependency) {
        delete dependency.target.phaseId;
        delete dependency.target.taskId;
    };

    $scope.updatePhaseDropdown = function (dependency) {
        delete dependency.target.taskId;
    };

    $scope.saveDependency = function () {
        if (!$scope.editedDependency || !$scope.draftDependency.target) {
            return;
        }

        function updateDependencyInList (updatedDependency) {
            var index = _.indexOf($scope.task.dependencies, $scope.editedDependency);
            if (index >= 0) {
                $scope.task.dependencies[index] = updatedDependency;
            }
            delete $scope.editedDependency;
            delete $scope.draftDependency;
        }

        if ($scope.editedDependency.id) {
            Backend.put('dependencies/' + $scope.editedDependency.id, $scope.draftDependency).success(updateDependencyInList);
        } else {
            Backend.post('gates/' + $scope.task.id + '/dependencies', $scope.draftDependency).success(updateDependencyInList);
        }
    };

    $scope.editDependency = function (dependency) {
        $scope.editedDependency = dependency;
        $scope.draftDependency = _.clone(dependency);
    };

    $scope.isEditingDependency = function (dependency) {
        return $scope.editedDependency === dependency;
    };

    $scope.cancelDependencyEditing = function () {
        if (!$scope.editedDependency.id) {
            $scope.task.dependencies = _.without($scope.task.dependencies, $scope.editedDependency);
        }
        delete $scope.editedDependency;
        delete $scope.draftDependency;
    };

    $scope.removeDependency = function (removedDependency) {
        Backend.del('dependencies/' + removedDependency.id).success(function () {
            $scope.task.dependencies = _.reject($scope.task.dependencies, function (dependency) {
                return removedDependency === dependency;
            });
        });
    };

    function getRelease(releaseId) {
        if (angular.isUndefined(releaseId) || releaseId === '') {
            return null;
        }
        return _.find($scope.dependencyTargetCandidates, function (candidate) {
            return candidate.id === releaseId;
        });
    }

    $scope.getPhases = function (releaseId) {
        var release = getRelease(releaseId);
        return release ? release.phases : [];
    };

    $scope.getTasks = function (releaseId, phaseId) {
        var phases = $scope.getPhases(releaseId);
        if (angular.isUndefined(phaseId) || phaseId === '') {
            return [];
        }
        var phase = _.find(phases,function (phase) {
            return phase.id === phaseId;
        });
        return phase ? phase.tasks : [];
    };

    $scope.getVariables = function (releaseId) {
        var release = getRelease(releaseId);
        return release ? release.variables : [];
    };

    $scope.getTitle = function (id, objects, variables) {
        if (!objects) {
            return '';
        }

        var object = _.find(objects, function (object) {
            return object.id === id;
        });

        var title = object ? object.title : '';
        return $scope.interpolate(title, variables);
    };
    
    $scope.interpolate = function (title, variables) {
        return VariablesInterpolator.interpolateInText(variables, title);
    };
}]);
