angular.module('xlrelease').directive('quickTaskGenerator', function () {
    function enableForm(scope) {
        scope.$apply(function () {
            scope.showForm = true;
        });
    }

    function submitTask(scope) {
        scope.$apply(function () {
            if (angular.isDefined(scope.title) && scope.title !== null && scope.title !== '') {
                var taskForm = {
                    title: scope.title,
                    taskType: scope.taskType
                };
                scope.addTask({'taskForm': taskForm });
                scope.title = '';
            }
        });
    }

    function disableForm(scope) {
        scope.$apply(function () {
            scope.showForm = false;
            scope.title = '';
        });
    }

    return {
        templateUrl: "partials/tasks/quick-task-generator.html",
        scope: {
            'addTask': '&',
            'pythonScriptDefinitions': '='
        },
        link: function (scope, element) {
            scope.showForm = false;
            scope.title = '';
            scope.taskType = 'xlrelease.Task';

            var input = element.find("input");


            element.find(".add-task").bind('click', function () {
                enableForm(scope);
                input.focus()
            });

            element.find(".add").bind('click', function () {
                submitTask(scope);
                input.focus();
            });

            element.find(".cancel").bind('click', function () {
                disableForm(scope);
            });

            input.bind('keyup', function (e) {
                if (e.which === 27) {   // on escape
                    disableForm(scope);
                }
                if (e.which == 13) {    // on enter
                    submitTask(scope);
                    input.focus();
                }
            });
        }
    }
});
