'use strict';

angular.module('xlrelease').controller('tasksController', ['$scope', 'Backend', 'Authenticator', 'TaskPolling', 'TasksService', 'Modal', 'FlagService', 'DateService', function ($scope, Backend, Authenticator, TaskPolling, TasksService, Modal, FlagService, DateService) {

    function loadTasks() {
        Backend.get('tasks', { params: $scope.filters }).success(function (releases) {
            $scope.releases = releases;
            startPolling();
        });
    }
    $scope.loadTasks = loadTasks;

    function startPolling() {
        var tasks = _.flatten(_.pluck($scope.releases, 'tasks'));
        TaskPolling.startTaskPolling(tasks, $scope).onTaskUpdate(loadTasks);
        Modal.withScope($scope).onNextOpen(stopPolling).onNextClose(startPolling);
    }

    function stopPolling() {
        $scope.$broadcast('STOP_TASK_POLLING');
    }

    $scope.filters = {
        active: true,
        assignedToMe: true,
        assignedToMyTeams: true,
        assignedToOthers: false,
        notAssigned: false,
        search: ''
    };

    $scope.delayedWatch(500, 'searchFilter', function (newSearch) {
        $scope.filters.search = newSearch;
    });
    $scope.$watchCollection('filters', loadTasks);

    $scope.isTaskPending = TasksService.isTaskPending;
    $scope.isTaskInProgress = TasksService.isTaskInProgress;
    $scope.isTaskPlanned = TasksService.isTaskPlanned;
    $scope.isTaskSkipped = TasksService.isTaskSkipped;
    $scope.isTaskFailed = TasksService.isTaskFailed;
    $scope.isTaskCompleted = TasksService.isTaskCompleted;
    $scope.isDeployitTask = TasksService.isDeployitTask;
    $scope.isGateTask = TasksService.isGateTask;
    $scope.isNotificationTask = TasksService.isNotificationTask;
    $scope.isManualTask = TasksService.isManualTask;
    $scope.isScriptTask = TasksService.isScriptTask;
    $scope.isStatusUpdatable = TasksService.isStatusUpdatable;
    $scope.hasOwner = TasksService.hasOwner;
    $scope.isTaskFlagged = FlagService.isTaskFlagged;
    $scope.isOverdue = DateService.isOverdue;

    $scope.completeTask = function (task, commentText) {
        TasksService.completeTask(task.id, commentText).success(loadTasks);
    };

    $scope.skipTask = function (task, commentText) {
        TasksService.skipTask(task.id, commentText).success(loadTasks);
    };

    $scope.failTask = function (task, commentText) {
        TasksService.failTask(task.id, commentText).success(loadTasks);
    };

    $scope.retryTask = function (task, commentText) {
        TasksService.retryTask(task.id, commentText).success(loadTasks);
    };

    $scope.startNow = function (task, commentText) {
        TasksService.startNow(task.id, commentText).success($scope.loadTasks);
    };
}]);
