'use strict';

angular.module('xlrelease').controller('templatePropertiesController', ['$scope', 'Backend', '$location', '$routeParams', '$window', 'Authenticator', function ($scope, Backend, $location, $routeParams, $window, Authenticator) {

    $scope.initTemplateForm = function () {
        delete $scope.templateUpdatedAt;

        Backend.get('releases/' + $routeParams.releaseId).success(function (template) {
            $scope.release = template;
            $scope.templateForm = {
                templateId: template.id,
                title: template.title,
                description: template.description,
                tags: template.tags
            };
        });
    };

    $scope.initNewTemplateForm = function () {
        $scope.templateForm = {
            newTemplate: true,
            tags: []
        };
    };

    if ($location.path().match('create$')) {
        $scope.initNewTemplateForm();
    } else {
        $scope.initTemplateForm();
    }

    $scope.copyTemplate = function () {
        Backend.post('releases/templates/copy', $scope.templateForm).success(function (releaseView) {
            $scope.templateForm = {};
            $location.path('/templates/' + releaseView.id);
        });
    };

    $scope.canEditTemplate = function() {
        if ($scope.templateForm && $scope.templateForm.newTemplate) {
            return Authenticator.hasPermission('template#create');
        }

        if ($scope.templateForm && $scope.templateForm.templateId) {
            return Authenticator.hasPermission('template#edit', $scope.templateForm.templateId);
        }

        return false;
    };

    $scope.templatePropertiesUpdated = function () {
        var template = {
            title: $scope.templateForm.title,
            description: $scope.templateForm.description,
            tags: $scope.templateForm.tags
        };
        if ($scope.templateForm.newTemplate) {
            Backend.post('releases/templates', template).success(function (releaseView) {
                $scope.templateForm = {};
                $location.path('/templates/' + releaseView.id);
            });
        } else {
            Backend.put('releases/templates/' + $scope.templateForm.templateId, template).success(function () {
                $scope.release.title = $scope.templateForm.title;
                $scope.templateUpdatedAt = moment().toDate();
            });
        }
    };

    $scope.back = function () {
        $window.history.back();
    };
}]);
