'use strict';

angular.module('xlrelease').factory('DateService', [function () {
    return {
        isOverdue: function (date) {
            if (!date) return false;
            return moment(date).isBefore();
        },
        getToday: function () {
            return this.atMidnight(moment());
        },
        getTodayWithTime: function () {
            return moment();
        },
        atMidnight: function (date) {
            return moment(date).hours(0).minutes(0).seconds(0).milliseconds(0);
        },
        getDateStatus: function (currentDay) {
            if (currentDay.isBefore(this.getToday())) {
                return 'past';
            } else if (currentDay.isAfter(this.getToday())) {
                return 'future';
            } else {
                return 'today';
            }
        }
    };
}]);
