angular.module('xlrelease').config(['$httpProvider', function ($httpProvider) {
    var INVALID_LICENSE_PAGE = '/invalid-license';
    var LOGIN_ENDPOINT = 'login';

    var UNAUTHORIZED_CODE = 401;
    var PAYMENT_REQUIRED = 402;
    var FORBIDDEN_CODE = 403;

    var DELAY_BEFORE_AJAX_SPINNER = 1000;
    var ajaxSpinnerTimers = [];

    $httpProvider.interceptors.push(['$rootScope', '$q', 'Alerts', '$location', function ($rootScope, $q, Alerts, $location) {
        return {
            request: function (request) {
                ajaxSpinnerTimers.push(setTimeout(function () {
                    angular.element('#loading').show();
                }, DELAY_BEFORE_AJAX_SPINNER));

                return request;
            },
            response: function (response) {
                hideSpinner();
                return response;
            },
            responseError: function (response) {
                hideSpinner();
                var status = response.status;
                var isLoginEndpoint = response.config.url === LOGIN_ENDPOINT;

                if (status === PAYMENT_REQUIRED) {
                    $location.path(INVALID_LICENSE_PAGE);
                    return $q.reject(response);
                }

                if (status === UNAUTHORIZED_CODE) {
                    if (!isLoginEndpoint) {
                        $rootScope.$emit('UNAUTHORIZED');
                    }
                    return $q.reject(response);
                }

                if (status === FORBIDDEN_CODE) {
                    if (!isLoginEndpoint) {
                        $rootScope.$emit('FORBIDDEN', response.data);
                    }
                    return $q.reject(response);
                }

                Alerts.addError('An error occured.');
                return $q.reject(response);
            }
        }
    }]);

    function hideSpinner() {
        clearTimeout(ajaxSpinnerTimers.pop());
        if (ajaxSpinnerTimers.length === 0) {
            angular.element('#loading').hide();
        }
    }
}]);
