angular.module('xlrelease').factory('Timeout', ['$rootScope', '$q', '$exceptionHandler', function ($rootScope, $q, $exceptionHandler) {
    var deferreds = {};

    function timeout(fn, delay) {
        var deferred = timeout._getDeferred();
        var timeoutId = timeout._registerTimeout(deferred, fn, delay);
        return buildPromise(deferred, timeoutId);
    }

    timeout.cancel = function (promise) {
        if (promise && promise.$$timeoutId in deferreds) {
            deferreds[promise.$$timeoutId].reject('canceled');
            clearTimeout(promise.$$timeoutId);
            return true;
        }
        return false;
    };

    // visible for testing
    timeout._getDeferred = function () {
        return $q.defer();
    };

    // visible for testing
    timeout._registerTimeout = function (deferred, fn, delay) {
        var timeoutId = setTimeout(function () {
            try {
                deferred.resolve(fn());
            } catch (e) {
                deferred.reject(e);
                $exceptionHandler(e);
            }
            $rootScope.$apply();
        }, delay);

        deferreds[timeoutId] = deferred;

        return  timeoutId;
    };

    // visible for testing
    timeout._cleanup = function (promise) {
        function cleanup() {
            delete deferreds[promise.$$timeoutId];
        }
        promise.then(cleanup, cleanup);
    };

    function buildPromise(deferred, timeoutId) {
        var promise = deferred.promise;

        promise.$$timeoutId = timeoutId;
        timeout._cleanup(promise);

        return promise;
    }

    return timeout;
}]);
