angular.module('xlrelease').directive('displayVariables', ['newlinesFilter', 'markdownFilter', 'VariablesInterpolator', function (newlinesFilter, markdownFilter, VariablesInterpolator) {

    function notNull(value, defaultValue) {
        return value ? value : defaultValue;
    }

    return function (scope, element, attrs) {
        scope.$watch('[' + attrs.displayVariables + ', ' + attrs.variables + ']', function (watchedValues) {
            var text = notNull(watchedValues[0], '');
            var variables = watchedValues[1];

            var markdown = (attrs.markdown !== undefined);
            var keepNewLines = (attrs.keepNewLines !== undefined);

            if (markdown) {
                text = markdownFilter(text);
            } else {
                text = _.escape(text);
            }
            if (keepNewLines) {
                text = newlinesFilter(text);
            }

            var html = VariablesInterpolator.interpolateInHtml(variables, text);
            element.html(html);
        }, true);
    };
}]);
