#
# Copyright (c) 2021. All rights reserved.
#
# This software and all trademarks, trade names, and logos included herein are the property of Digital.ai, Inc. and its affiliates, subsidiaries, and licensors.
#
import sys
import urllib2
import base64
import sets
import json
import com.xhaus.jyson.JysonCodec as json
import com.xebialabs.xlrelease.plugin.argocd.RemoteScript as RemoteScript
from kubeconfig_parser import kubeconfigParser

class APIClient:

    def __init__(self, host, kubeconfig_path=None, kubectl_path=None):
        self.remote = RemoteScript(host)
        self.kubeconfig_path = kubeconfig_path
        self.kubectl_path = kubectl_path


    def execute_kubernetes_spec(self, spec, command ,cmd_params = None):
        response = self.remote.executeKubernetesSpec(spec,'%s %s %s -f ' % (self.kubectl_path, command, cmd_params if cmd_params else ''))
        return response

    def execute_command(self,command):
        response = self.remote.executeScript(command)
        return response

    @staticmethod
    def download_file(url, username, password):
        request=urllib2.Request(url)
        if (username is not None) and (password is not None):
            base64string = base64.encodestring('%s:%s' % (username, password))[:-1]
            auth_header =  "Basic %s" % base64string
            request.add_header("Authorization", auth_header)

        return urllib2.urlopen(request).read()
        
    def getCurrentKubeContext(self):
        command = "cat %s" % (self.kubeconfig_path)
        response = self.remote.executeScript(command)
        parser = kubeconfigParser(response.stdout)
        response1 = parser.get_current_context()
        return response1