#
# Copyright (c) 2021. All rights reserved.
#
# This software and all trademarks, trade names, and logos included herein are the property of Digital.ai, Inc. and its affiliates, subsidiaries, and licensors.
#
import json

from java.text import SimpleDateFormat
from java.util import TimeZone

global CI
global input, config
from argocd.status import map_status_group
from argocd.argocd_rest_client import RestClient
from argocd.status import map_cluster_names
from com.xebialabs.deployit.util import PasswordEncrypter


def parse_content(content, clusters):
    if content:
        version_tag = None
        if 'versionTag' in content:
            version_tag = content['versionTag']

        destination = None
        if 'destination' in content:
            destination = clusters[content['destination']] if clusters[content['destination']] is not None else content['destination']

        destination_uid = None
        if 'destinationUid' in content:
            destination_uid = content['destinationUid']

        namespace = None
        if 'namespace' in content:
            namespace = content['namespace']

        deployment_metadata = None

        status = None
        if 'state' in content:
            state = content['state']
            version_tag = state['versionTag']
            destination = clusters[state['destination']] if clusters[state['destination']] is not None else state['destination']
            destination_uid = state['destinationUid']
            namespace = state['namespace']
            last_change = state['creationTimestamp'] if has_no_value(state['lastChangeTime']) else state['lastChangeTime']
            sdf = SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss'Z'")
            sdf.setTimeZone(TimeZone.getTimeZone("UTC"))
            change_time = None if last_change is None else sdf.parse(last_change)
            status = state['deploymentStatus']
            deployment_metadata = CI('events.WebhookStatusDeploymentMetadata', {
                'deploymentType': state['deploymentType'],
                'deploymentStatus': status,
                'user': state['user'],
                'lastChangeTime': change_time,
            })

        return CI("events.StatusWebhookEvent", {
            'operation': content['operation'] if 'operation' in content else None,
            'applicationName': content['applicationName'],
            'applicationUid': namespace + ":" + content['applicationName'],
            'applicationPath': content['applicationPath'],
            'versionLabel': version_tag['label'],
            'versionState': version_tag['state'],
            'destination': destination,
            'destinationUid': destination_uid,
            'namespace': namespace,
            'statusGroup': map_status_group(status),
            'deploymentMetadata': deployment_metadata
        })
    else:
        return None


def has_no_value(value):
    if value is None or 'no value' in value:
        return True
    return False


encrypter = PasswordEncrypter.getInstance()
argo_server = {
    'url': config.sourceServer.url,
    'username': config.sourceServer.username,
    'password': encrypter.ensureDecrypted(config.sourceServer.password),
    'authToken': encrypter.ensureDecrypted(config.sourceServer.authToken)
}
client = RestClient(argo_server=argo_server)
clusters = map_cluster_names(client.listClusters(), config.sourceServer.title)

output = parse_content(json.loads(input.content), clusters)
