#
# Copyright (c) 2021. All rights reserved.
#
# This software and all trademarks, trade names, and logos included herein are the property of Digital.ai, Inc. and its affiliates, subsidiaries, and licensors.
#
import logging

from argocd.argocd_rest_client import RestClient

from com.xebialabs.xlrelease.lookup.api.internal import LookupResultElement

logger = logging.getLogger("ListCharts")
logger.addHandler(logging.StreamHandler(sys.stdout))

repo_objs = RestClient(argo_server=argocdServer).getRepoConnections()
repo_objs = repo_objs["items"]

chart_list = []
for repo in repo_objs:
    if repo["repo"] == url and repo["type"] == "helm":
        chart_versions = RestClient(argo_server=argocdServer).getChartVersions(url)
        chart_versions = chart_versions["items"]
        for chart in chart_versions:
            chart_list.append(LookupResultElement(chart["name"], chart["name"]))

        result = chart_list
