#
# Copyright (c) 2021. All rights reserved.
#
# This software and all trademarks, trade names, and logos included herein are the property of Digital.ai, Inc. and its affiliates, subsidiaries, and licensors.
#

from argocd.argocd_rest_client import RestClient

def validate_mandatory_field(field, error):
    if not field:
        raise ValueError(error)

validate_mandatory_field(argocdServer, "Missing value for ArgoCD Server")
validate_mandatory_field(appName, "Missing value for App Name")

response = RestClient(argo_server=argocdServer).rollbackApplication(historyid, appName, appNamespace, pruneResources, dryRun)

rollbackStatus = response["status"]["sync"]["status"]
revisionId = response["status"]["sync"]["revision"]
task.setStatusLine("Sync status: %s" % rollbackStatus)

if waitForSuccessfulRollback and rollbackStatus != "Synced":
    if rollbackStatus == "syncFailed":
        raise ValueError('Rollback failed. %s'.format(response["message"]))
    task.schedule("argocd/waitForSuccessfulRollback.py")
else:
    task.setStatusLine("Rollback completed")
    status = rollbackStatus
    revision = revisionId