#
# Copyright (c) 2021. All rights reserved.
#
# This software and all trademarks, trade names, and logos included herein are the property of Digital.ai, Inc. and its affiliates, subsidiaries, and licensors.
#

from argocd.argocd_rest_client import RestClient
from argocd.util import validate_mandatory_field

validate_mandatory_field(argocdServer, "Missing value for ArgoCD Server")
validate_mandatory_field(appName, "Missing value for Application Name")

output = {}
client = RestClient(argo_server=argocdServer)
bearer_token = client.getBearerToken()
response = client.getAppDetails(appName, bearer_token)

output["status"] = response.get("status", {})
output["metadata"] = response.get("metadata", {})
output["spec"] = response.get("spec", {})