#
# Copyright (c) 2021. All rights reserved.
#
# This software and all trademarks, trade names, and logos included herein are the property of Digital.ai, Inc. and its affiliates, subsidiaries, and licensors.
#
import json
from xlrelease.HttpRequest import HttpRequest
from argocd.argocd_rest_client import RestClient

def validate_mandatory_field(field, error):
    if not field:
        raise ValueError(error)

validate_mandatory_field(argocdServer, "Missing value for ArgoCD Server")
validate_mandatory_field(appName, "Missing value for App Name")

response = RestClient(argo_server=argocdServer).syncApplication(appName, autoCreateNamespace, refresh, pruneResources, prunePropagationPolicy, serverSideApply)

status = response["status"]
task.setStatusLine("Sync status is %s" % status)
if waitForSuccessfulSync and status != "Synced":
    task.schedule("argocd/getSyncStatus-waitForSuccessfulSync.py")
else:
    syncResult = status
    if "revision" in response:
        revision = response["revision"]
