#
# Copyright (c) 2021. All rights reserved.
#
# This software and all trademarks, trade names, and logos included herein are the property of Digital.ai, Inc. and its affiliates, subsidiaries, and licensors.
#

import json

global input
global config


def filter_folders(content, filtered_folders):
    if not filtered_folders:
        return True

    if content:
        project = None
        if 'project' in content:
            project = content['project']

        if 'state' in content:
            state = content['state']
            project = state['project']

        if project in filtered_folders:
            return True

    return False


def filter_content(content):
    if content:
        version_tag = None
        if 'versionTag' in content:
            version_tag = content['versionTag']

        if 'state' in content:
            state = content['state']
            version_tag = state['versionTag']

        version_label = version_tag['label']
        if has_no_value(version_label):
            return False

    return True


def has_no_value(value):
    if value is None or 'no value' in value:
        return True
    return False


accepted = filter_content(json.loads(input.content)) and filter_folders(json.loads(input.content), config.filteredFolders)
