#
# Copyright (c) 2021. All rights reserved.
#
# This software and all trademarks, trade names, and logos included herein are the property of Digital.ai, Inc. and its affiliates, subsidiaries, and licensors.
#

from argocd.argocd_rest_client import RestClient
from argocd.util import validate_mandatory_field

validate_mandatory_field(argocdServer, "ArgoCD server not configured")
validate_mandatory_field(repo, "Repository URL not configured")
validate_mandatory_field(pathOrChart, "Path or chart not configured")
validate_mandatory_field(cluster, "Cluster URL not configured")

result = RestClient(argo_server=argocdServer).checkIfApplicationExists(repo, pathOrChart, targetRevision, cluster)
status = {"exists": result}
