#
# Copyright (c) 2021. All rights reserved.
#
# This software and all trademarks, trade names, and logos included herein are the property of Digital.ai, Inc. and its affiliates, subsidiaries, and licensors.
#
from argocd.argocd_rest_client import RestClient
from argocd.util import validate_mandatory_field
import json 
from collections import OrderedDict


validate_mandatory_field(argocdServer, "Missing value for ArgoCD Server")
validate_mandatory_field(appName, "Missing value for App Name")
validate_mandatory_field(project, "Missing value for Project")
validate_mandatory_field(namespace, "Missing value for Namespace")

repo_list = RestClient(argo_server=argocdServer).getRepoConnections()
repo_list = repo_list.get("items") if repo_list.get("items") is not None else []

repo_obj = None
for repo in repo_list:
    if repo["repo"] == url:
        repo_obj = repo

repoType = 'git'

if repo_obj:
    repoType = repo_obj["type"]
    if repo_obj["type"] == "git":
        if not path:
            raise ValueError('Path cannot be empty')
    elif repo_obj["type"] == "helm":
        if not chartName or not revision:
            raise ValueError('Chart name and version cannot be empty')
else:
    if not path and not chartName and not revision:
        raise ValueError('Chart name, version or path should be specified')

response = {}
argo_client = RestClient(argo_server=argocdServer)
response = argo_client.createApplication(appName, project, server, namespace, url, repoType,
                                                      path, chartName, revision, helmFileParameters, ignoreMissingValueFiles,
                                                        parameters, passCredentials, releaseName, skipCrds, valueFiles, values,
                                                          helmTemplatingVersion, upsert, validate, autoSync, pruneResources, selfHeal, 
                                                          skipValidation, pruneLast, autoCreateNamespace, applyOutOfSyncOnly, prunePropagationPolicy, 
                                                          replace, kustomizeCommonAnnotations, commonAnnotationsEnvsubst, kustomizeCommonLabels, 
                                                          forceCommonAnnotations, forceCommonLabels, kustomizeImages, kustomizeNamePrefix, 
                                                          kustomizeNameSuffix, kustomizeNamespace, kustomizeVersion, forceHelmParameters)



app_status = argo_client.getSyncStatus(appName)

if app_status["status"]["syncStatus"] == "Unknown":
    raise ValueError("Application created with failures. Please check status for more details. %s" % app_status["conditions"])

applicationName = appName

