/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.xlrelease.auth.oidc.interceptor;

import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.http.HttpRequest;
import org.springframework.http.client.ClientHttpRequestExecution;
import org.springframework.http.client.ClientHttpRequestInterceptor;
import org.springframework.http.client.ClientHttpResponse;
import org.springframework.util.StreamUtils;

public class RequestResponseLoggingInterceptor
implements ClientHttpRequestInterceptor {
    private static final Logger logger = LoggerFactory.getLogger(RequestResponseLoggingInterceptor.class);

    public ClientHttpResponse intercept(HttpRequest request, byte[] body, ClientHttpRequestExecution execution) throws IOException {
        this.logRequest(request, body);
        ClientHttpResponse response = execution.execute(request, body);
        this.logResponse(response);
        return response;
    }

    private void logRequest(HttpRequest request, byte[] body) {
        if (logger.isDebugEnabled()) {
            logger.debug("===========================request begin============================================");
            logger.debug("URI         : {}", (Object)request.getURI());
            logger.debug("Method      : {}", (Object)request.getMethod());
            logger.debug("Headers     : {}", (Object)request.getHeaders());
            logger.debug("Request body: {}", (Object)new String(body, StandardCharsets.UTF_8));
            logger.debug("==========================request end===============================================");
        }
    }

    private void logResponse(ClientHttpResponse response) throws IOException {
        if (logger.isDebugEnabled()) {
            logger.debug("============================response begin==========================================");
            logger.debug("Status code  : {}", (Object)response.getStatusCode());
            logger.debug("Status text  : {}", (Object)response.getStatusText());
            logger.debug("Headers      : {}", (Object)response.getHeaders());
            logger.debug("Response body: {}", (Object)StreamUtils.copyToString((InputStream)response.getBody(), (Charset)Charset.defaultCharset()));
            logger.debug("============================response end============================================");
        }
    }
}

