/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.xlrelease.versioning.scm.connector;

import com.xebialabs.deployit.booter.local.utils.Strings;
import com.xebialabs.deployit.util.PasswordEncrypter;
import com.xebialabs.xlrelease.domain.UserProfile;
import com.xebialabs.xlrelease.plugin.git.GitClient;
import com.xebialabs.xlrelease.plugin.git.GitConnectionSettings;
import com.xebialabs.xlrelease.versioning.TemplateVersioningException;
import com.xebialabs.xlrelease.versioning.TemplateVersioningException$;
import com.xebialabs.xlrelease.versioning.scm.connector.Blobs;
import com.xebialabs.xlrelease.versioning.scm.connector.JGitConnector$;
import com.xebialabs.xlrelease.versioning.scm.connector.JGitConnectorConfig;
import com.xebialabs.xlrelease.versioning.scm.connector.ScmConnector;
import com.xebialabs.xlrelease.versioning.scm.connector.ValidatedCommitInfo;
import java.io.File;
import java.io.Serializable;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.util.Arrays;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import org.eclipse.jgit.api.Git;
import org.eclipse.jgit.api.PullResult;
import org.eclipse.jgit.api.ResetCommand;
import org.eclipse.jgit.lib.PersonIdent;
import org.eclipse.jgit.lib.Repository;
import org.eclipse.jgit.lib.RepositoryCache;
import org.eclipse.jgit.merge.MergeStrategy;
import org.eclipse.jgit.revwalk.RevCommit;
import org.eclipse.jgit.revwalk.RevObject;
import org.eclipse.jgit.transport.PushResult;
import org.eclipse.jgit.transport.RemoteRefUpdate;
import org.eclipse.jgit.util.FS;
import scala.Function0;
import scala.Function1;
import scala.Predef$;
import scala.collection.JavaConverters$;
import scala.collection.TraversableOnce;
import scala.collection.immutable.StringOps;
import scala.collection.mutable.ArrayOps;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.java8.JFunction0;
import scala.util.Failure;
import scala.util.Success;
import scala.util.Try;
import scala.util.Try$;

@ScalaSignature(bytes="\u0006\u0001\u0005\rv!\u0002\u0012$\u0011\u0003\u0001d!\u0002\u001a$\u0011\u0003\u0019\u0004\"\u0002\u001e\u0002\t\u0003Y\u0004\u0002\u0003\u001f\u0002\u0011\u000b\u0007I\u0011A\u001f\t\u000b%\u000bA\u0011\u0001&\t\u000f\u0005U\u0015\u0001\"\u0001\u0002\u0018\"9\u00111T\u0001\u0005\u0002\u0005u\u0005BBAQ\u0003\u0011%QH\u0002\u00033G\u0001a\u0005\u0002\u0003)\t\u0005\u0003\u0005\u000b\u0011B)\t\u000biBA\u0011\u0001+\t\u000fYC!\u0019!C\u0001{!1q\u000b\u0003Q\u0001\nyBq\u0001\u0017\u0005C\u0002\u0013%Q\b\u0003\u0004Z\u0011\u0001\u0006IA\u0010\u0005\b5\"\u0011\r\u0011\"\u0001>\u0011\u0019Y\u0006\u0002)A\u0005}!IA\f\u0003a\u0001\u0002\u0004%\t!\u0018\u0005\nM\"\u0001\r\u00111A\u0005\u0002\u001dD\u0011\"\u001c\u0005A\u0002\u0003\u0005\u000b\u0015\u00020\t\u00139D\u0001\u0019!a\u0001\n\u0013y\u0007\"\u0003?\t\u0001\u0004\u0005\r\u0011\"\u0003~\u0011%y\b\u00021A\u0001B\u0003&\u0001\u000fC\u0004\u0002\u0002!!\t%a\u0001\t\u000f\u0005=\u0001\u0002\"\u0011\u0002\u0012!9\u0011q\u0004\u0005\u0005R\u0005\u0005\u0002bBA!\u0011\u0011E\u00131\t\u0005\b\u0003#BA\u0011KA*\u0011\u001d\t)\u0006\u0003C\u0005\u0003/Bq!!\u0019\t\t\u0013\t\u0019\u0007\u0003\u0004\u0002x!!Ia\u001c\u0005\b\u0003sBA\u0011BA>\u0011\u001d\ti\b\u0003C\u0005\u0003#Aq!a \t\t\u0013\t\t)A\u0007K\u000f&$8i\u001c8oK\u000e$xN\u001d\u0006\u0003I\u0015\n\u0011bY8o]\u0016\u001cGo\u001c:\u000b\u0005\u0019:\u0013aA:d[*\u0011\u0001&K\u0001\u000bm\u0016\u00148/[8oS:<'B\u0001\u0016,\u0003%AHN]3mK\u0006\u001cXM\u0003\u0002-[\u0005I\u00010\u001a2jC2\f'm\u001d\u0006\u0002]\u0005\u00191m\\7\u0004\u0001A\u0011\u0011'A\u0007\u0002G\ti!jR5u\u0007>tg.Z2u_J\u001c\"!\u0001\u001b\u0011\u0005UBT\"\u0001\u001c\u000b\u0003]\nQa]2bY\u0006L!!\u000f\u001c\u0003\r\u0005s\u0017PU3g\u0003\u0019a\u0014N\\5u}Q\t\u0001'A\nE\u000b\u001a\u000bU\u000b\u0014+`'\u000ekulV(S\u0017\u0012K%+F\u0001?!\tydI\u0004\u0002A\tB\u0011\u0011IN\u0007\u0002\u0005*\u00111iL\u0001\u0007yI|w\u000e\u001e \n\u0005\u00153\u0014A\u0002)sK\u0012,g-\u0003\u0002H\u0011\n11\u000b\u001e:j]\u001eT!!\u0012\u001c\u0002\u000b\u0005\u0004\b\u000f\\=\u0015\u0007-\u000b\u0019\n\u0005\u00022\u0011M\u0019\u0001\u0002N'\u0011\u0005Er\u0015BA($\u00051\u00196-\\\"p]:,7\r^8s\u0003\u0019\u0019wN\u001c4jOB\u0011\u0011GU\u0005\u0003'\u000e\u00121CS$ji\u000e{gN\\3di>\u00148i\u001c8gS\u001e$\"aS+\t\u000bAS\u0001\u0019A)\u0002\u001d\u0019,H\u000e\u001c\"sC:\u001c\u0007NT1nK\u0006ya-\u001e7m\u0005J\fgn\u00195OC6,\u0007%\u0001\u0005sKB|g.Y7f\u0003%\u0011X\r]8oC6,\u0007%A\u0006sKB|G)\u001b:QCRD\u0017\u0001\u0004:fa>$\u0015N\u001d)bi\"\u0004\u0013!C4ji\u000ec\u0017.\u001a8u+\u0005q\u0006CA0e\u001b\u0005\u0001'BA1c\u0003\r9\u0017\u000e\u001e\u0006\u0003G&\na\u0001\u001d7vO&t\u0017BA3a\u0005%9\u0015\u000e^\"mS\u0016tG/A\u0007hSR\u001cE.[3oi~#S-\u001d\u000b\u0003Q.\u0004\"!N5\n\u0005)4$\u0001B+oSRDq\u0001\u001c\n\u0002\u0002\u0003\u0007a,A\u0002yIE\n!bZ5u\u00072LWM\u001c;!\u0003\u0011yv-\u001b;\u0016\u0003A\u0004\"!\u001d>\u000e\u0003IT!a\u001d;\u0002\u0007\u0005\u0004\u0018N\u0003\u0002vm\u0006!!nZ5u\u0015\t9\b0A\u0004fG2L\u0007o]3\u000b\u0003e\f1a\u001c:h\u0013\tY(OA\u0002HSR\f\u0001bX4ji~#S-\u001d\u000b\u0003QzDq\u0001\\\u000b\u0002\u0002\u0003\u0007\u0001/A\u0003`O&$\b%A\u0007hKRLE-\u001a8uS\u001aLWM\u001d\u000b\u0004}\u0005\u0015\u0001bBA\u0004/\u0001\u0007\u0011\u0011B\u0001\u0006E2|'m\u001d\t\u0004c\u0005-\u0011bAA\u0007G\t)!\t\\8cg\u0006\u00012m\u001c8oK\u000e$\u0018n\u001c8Ti\u0006$Xo\u001d\u000b\u0003\u0003'\u0001R!!\u0006\u0002\u001c!l!!a\u0006\u000b\u0007\u0005ea'\u0001\u0003vi&d\u0017\u0002BA\u000f\u0003/\u00111\u0001\u0016:z\u00031\u0019w.\\7ji\u0006sG\rV1h)!\t\u0019#!\n\u0002(\u0005E\u0002#BA\u000b\u00037q\u0004bBA\u00043\u0001\u0007\u0011\u0011\u0002\u0005\b\u0003SI\u0002\u0019AA\u0016\u0003)\u0019w.\\7ji&sgm\u001c\t\u0004c\u00055\u0012bAA\u0018G\t\u0019b+\u00197jI\u0006$X\rZ\"p[6LG/\u00138g_\"9\u00111G\rA\u0002\u0005U\u0012\u0001B;tKJ\u0004B!a\u000e\u0002>5\u0011\u0011\u0011\b\u0006\u0004\u0003wI\u0013A\u00023p[\u0006Lg.\u0003\u0003\u0002@\u0005e\"aC+tKJ\u0004&o\u001c4jY\u0016\fQ\u0002^1h\u001d>$\bK]3tK:$H\u0003BA#\u0003\u001b\u0002b!!\u0006\u0002\u001c\u0005\u001d\u0003cA\u001b\u0002J%\u0019\u00111\n\u001c\u0003\u000f\t{w\u000e\\3b]\"1\u0011q\n\u000eA\u0002y\n1\u0001^1h\u0003A\u0019G.Z1okB\u0014Vm]8ve\u000e,7\u000fF\u0001i\u0003\u001d9\u0017\u000e\u001e)vY2$B!!\u0017\u0002`A\u0019\u0011/a\u0017\n\u0007\u0005u#O\u0001\u0006Qk2d'+Z:vYRDQ!\u0019\u000fA\u0002A\fqaZ5u!V\u001c\b\u000e\u0006\u0003\u0002f\u0005U\u0004\u0003BA4\u0003cj!!!\u001b\u000b\t\u0005-\u0014QN\u0001\u0010%\u0016lw\u000e^3SK\u001a,\u0006\u000fZ1uK*\u0019\u0011q\u000e;\u0002\u0013Q\u0014\u0018M\\:q_J$\u0018\u0002BA:\u0003S\u0012aa\u0015;biV\u001c\b\"B1\u001e\u0001\u0004\u0001\u0018AB4fi\u001eKG/\u0001\u0005j]&$(+\u001a9p)\u0005\u0001\u0018\u0001\u0006<fe&4\u0017PU3q_NLGo\u001c:z!\u0006$\b.A\u0005hKR\fU\u000f\u001e5peR!\u00111QAH!\u0011\t))a#\u000e\u0005\u0005\u001d%bAAEi\u0006\u0019A.\u001b2\n\t\u00055\u0015q\u0011\u0002\f!\u0016\u00148o\u001c8JI\u0016tG\u000fC\u0004\u0002\u0012\u0006\u0002\r!!\u000e\u0002\u0017U\u001cXM\u001d)s_\u001aLG.\u001a\u0005\u0006!\u0012\u0001\r!U\u0001\u000bI\u0016dW\r^3SKB|Gc\u00015\u0002\u001a\")\u0001+\u0002a\u0001#\u0006\u0001r-\u001a;D_:4\u0017n\u001a#jeB\u000bG\u000f\u001b\u000b\u0004}\u0005}\u0005\"\u0002)\u0007\u0001\u0004\t\u0016AD4fi^{'o\u001b3jeB\u000bG\u000f\u001b")
public class JGitConnector
implements ScmConnector {
    private final JGitConnectorConfig config;
    private final String fullBranchName;
    private final String reponame;
    private final String repoDirPath;
    private GitClient gitClient;
    private Git _git;

    public static String getConfigDirPath(JGitConnectorConfig jGitConnectorConfig) {
        return JGitConnector$.MODULE$.getConfigDirPath(jGitConnectorConfig);
    }

    public static void deleteRepo(JGitConnectorConfig jGitConnectorConfig) {
        JGitConnector$.MODULE$.deleteRepo(jGitConnectorConfig);
    }

    public static JGitConnector apply(JGitConnectorConfig jGitConnectorConfig) {
        return JGitConnector$.MODULE$.apply(jGitConnectorConfig);
    }

    public static String DEFAULT_SCM_WORKDIR() {
        return JGitConnector$.MODULE$.DEFAULT_SCM_WORKDIR();
    }

    public Try<String> createNewVersion(Blobs blobs, ValidatedCommitInfo commitInfo, UserProfile user) {
        return ScmConnector.createNewVersion$((ScmConnector)this, (Blobs)blobs, (ValidatedCommitInfo)commitInfo, (UserProfile)user);
    }

    public String fullBranchName() {
        return this.fullBranchName;
    }

    private String reponame() {
        return this.reponame;
    }

    public String repoDirPath() {
        return this.repoDirPath;
    }

    public GitClient gitClient() {
        return this.gitClient;
    }

    public void gitClient_$eq(GitClient x$1) {
        this.gitClient = x$1;
    }

    private Git _git() {
        return this._git;
    }

    private void _git_$eq(Git x$1) {
        this._git = x$1;
    }

    public String getIdentifier(Blobs blobs) {
        return new StringBuilder(1).append(this.config.url()).append("/").append(blobs.templateFilePath()).toString();
    }

    public Try<BoxedUnit> connectionStatus() {
        Try refs = this.verifyRepositoryPath().flatMap((Function1 & Serializable & scala.Serializable)_ -> Try$.MODULE$.apply((Function0 & Serializable & scala.Serializable)() -> Git.lsRemoteRepository().setRemote($this.config.url()).setHeads(true).setTags(false).callAsMap().keySet()).map((Function1 & Serializable & scala.Serializable)remoteRefs -> remoteRefs));
        return refs.flatMap((Function1 & Serializable & scala.Serializable)r -> r.isEmpty() ? new Failure((Throwable)new TemplateVersioningException("The remote repository is empty", TemplateVersioningException$.MODULE$.apply$default$2(), TemplateVersioningException$.MODULE$.apply$default$3())) : (!r.contains(this.fullBranchName()) ? new Failure((Throwable)new TemplateVersioningException(new StringBuilder(43).append("Branch ").append($this.config.branch()).append(" does not exist in remote repository").toString(), TemplateVersioningException$.MODULE$.apply$default$2(), TemplateVersioningException$.MODULE$.apply$default$3())) : new Success((Object)BoxedUnit.UNIT)));
    }

    public Try<String> commitAndTag(Blobs blobs, ValidatedCommitInfo commitInfo, UserProfile user) {
        return Try$.MODULE$.apply((Function0 & Serializable & scala.Serializable)() -> {
            RevCommit revCommit;
            Git git;
            block7: {
                block4: {
                    block6: {
                        RemoteRefUpdate.Status reAttemptPushStatus;
                        block5: {
                            RemoteRefUpdate.Status pushStatus;
                            git = this.getGit();
                            Repository repo = git.getRepository();
                            File templateFile = new File(repo.getDirectory().getParent(), blobs.templateFilePath());
                            templateFile.getParentFile().mkdirs();
                            File attachmentsDirectory = new File(repo.getDirectory().getParent(), blobs.attachments().folderName());
                            attachmentsDirectory.mkdirs();
                            Files.write(templateFile.toPath(), (byte[])blobs.dsl().getContent().apply(), new OpenOption[0]);
                            blobs.attachments().files().foreach((Function1 & Serializable & scala.Serializable)attachment -> {
                                File attachmentFile = new File(attachmentsDirectory, attachment.fileName());
                                return Files.write(attachmentFile.toPath(), (byte[])attachment.getContent().apply(), new OpenOption[0]);
                            });
                            git.add().addFilepattern(".").call();
                            PersonIdent committer = new PersonIdent(repo);
                            revCommit = git.commit().setCommitter(committer).setAuthor(this.getAuthor(user)).setMessage(commitInfo.message()).call();
                            git.tag().setAnnotated(false).setObjectId((RevObject)revCommit).setName(commitInfo.tag().refName()).call();
                            RemoteRefUpdate.Status status = pushStatus = this.gitPush(git);
                            boolean bl = RemoteRefUpdate.Status.NON_EXISTING.equals(status) ? true : RemoteRefUpdate.Status.REJECTED_OTHER_REASON.equals(status);
                            if (bl) {
                                JGitConnector$.MODULE$.deleteRepo($this.config);
                                throw new TemplateVersioningException(new StringBuilder(46).append("Unable to push to remote repository. Status: [").append(pushStatus.name()).toString(), TemplateVersioningException$.MODULE$.apply$default$2(), TemplateVersioningException$.MODULE$.apply$default$3());
                            }
                            boolean bl2 = RemoteRefUpdate.Status.REJECTED_NONFASTFORWARD.equals(status) ? true : RemoteRefUpdate.Status.REJECTED_REMOTE_CHANGED.equals(status);
                            if (!bl2) break block4;
                            this.gitPull(git);
                            RemoteRefUpdate.Status status2 = reAttemptPushStatus = this.gitPush(git);
                            RemoteRefUpdate.Status status3 = RemoteRefUpdate.Status.REJECTED_NONFASTFORWARD;
                            if (!(status2 == null ? status3 != null : !status2.equals(status3))) break block5;
                            RemoteRefUpdate.Status status4 = reAttemptPushStatus;
                            RemoteRefUpdate.Status status5 = RemoteRefUpdate.Status.REJECTED_REMOTE_CHANGED;
                            if (!(status4 == null ? status5 != null : !status4.equals(status5))) break block5;
                            RemoteRefUpdate.Status status6 = reAttemptPushStatus;
                            RemoteRefUpdate.Status status7 = RemoteRefUpdate.Status.NON_EXISTING;
                            if (!(status6 == null ? status7 != null : !status6.equals(status7))) break block5;
                            RemoteRefUpdate.Status status8 = reAttemptPushStatus;
                            RemoteRefUpdate.Status status9 = RemoteRefUpdate.Status.REJECTED_OTHER_REASON;
                            if (status8 != null ? !status8.equals(status9) : status9 != null) break block6;
                        }
                        JGitConnector$.MODULE$.deleteRepo($this.config);
                        throw new TemplateVersioningException(new StringBuilder(46).append("Unable to push to remote repository. Status: [").append(reAttemptPushStatus.name()).toString(), TemplateVersioningException$.MODULE$.apply$default$2(), TemplateVersioningException$.MODULE$.apply$default$3());
                    }
                    BoxedUnit boxedUnit = BoxedUnit.UNIT;
                    break block7;
                }
                BoxedUnit boxedUnit = BoxedUnit.UNIT;
            }
            git.push().setPushTags().call();
            return revCommit.getName();
        });
    }

    public Try<Object> tagNotPresent(String tag) {
        return Try$.MODULE$.apply((Function0)(JFunction0.mcZ.sp & Serializable & scala.Serializable)() -> {
            Set tags = this.getGit().tagList().call().stream().map(x$2 -> x$2.getName()).collect(Collectors.toSet());
            return !tags.contains(new StringBuilder(10).append("refs/tags/").append(tag).toString());
        });
    }

    public void cleanupResources() {
        block0: {
            if (this._git() == null) break block0;
            this._git().close();
            this._git_$eq(null);
        }
    }

    private PullResult gitPull(Git git) {
        return git.pull().setStrategy(MergeStrategy.THEIRS).call();
    }

    private RemoteRefUpdate.Status gitPush(Git git) {
        PushResult pushResultCommit = (PushResult)((TraversableOnce)JavaConverters$.MODULE$.iterableAsScalaIterableConverter(git.push().call()).asScala()).toList().head();
        return pushResultCommit.getRemoteUpdate(this.fullBranchName()).getStatus();
    }

    /*
     * WARNING - void declaration
     */
    private Git getGit() {
        Git git;
        if (this._git() != null) {
            git = this._git();
        } else {
            Git git2;
            File repoGitMetadataDir = new File(new StringBuilder(5).append(this.repoDirPath()).append("/.git").toString());
            boolean gitRepoExists = RepositoryCache.FileKey.isGitRepository((File)repoGitMetadataDir, (FS)FS.DETECTED);
            if (gitRepoExists) {
                void var3_3;
                Git tmpGit = Git.open((File)repoGitMetadataDir);
                tmpGit.reset().setMode(ResetCommand.ResetType.HARD).call();
                this.gitPull(tmpGit);
                git2 = var3_3;
            } else {
                git2 = this.initRepo();
            }
            this._git_$eq(git2);
            git = this._git();
        }
        return git;
    }

    private Git initRepo() {
        JGitConnector$.MODULE$.deleteRepo(this.config);
        File workDir = new File(this.repoDirPath());
        workDir.mkdirs();
        return Git.cloneRepository().setURI(this.config.url()).setDirectory(workDir).setBranchesToClone(Arrays.asList((Object[])new String[]{this.fullBranchName()})).setBranch(this.fullBranchName()).call();
    }

    private Try<BoxedUnit> verifyRepositoryPath() {
        return this.config.url() != null && new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])new StringOps(Predef$.MODULE$.augmentString(this.config.url())).split('/'))).takeRight(2))).lengthCompare(2) == 0 ? new Success((Object)BoxedUnit.UNIT) : new Failure((Throwable)new TemplateVersioningException(new StringBuilder(26).append("Invalid repository format ").append(this.config.url()).toString(), TemplateVersioningException$.MODULE$.apply$default$2(), TemplateVersioningException$.MODULE$.apply$default$3()));
    }

    private PersonIdent getAuthor(UserProfile userProfile) {
        return new PersonIdent(Strings.isNotBlank((String)userProfile.getFullName()) ? userProfile.getFullName() : userProfile.getCanonicalId(), Objects.toString(userProfile.getEmail(), ""));
    }

    public JGitConnector(JGitConnectorConfig config) {
        this.config = config;
        ScmConnector.$init$((ScmConnector)this);
        this.fullBranchName = new StringBuilder(11).append("refs/heads/").append(config.branch()).toString();
        this.reponame = new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])new StringOps(Predef$.MODULE$.augmentString(config.url())).split('/'))).takeRight(2))).mkString("_");
        this.repoDirPath = new StringBuilder(2).append(JGitConnector$.MODULE$.getConfigDirPath(config)).append("/").append(this.reponame()).append("_").append(config.branch()).toString();
        try {
            this.gitClient_$eq(new GitClient(new GitConnectionSettings(config.url(), config.branch(), config.authenticationMethod().name(), config.username(), PasswordEncrypter.getInstance().ensureDecrypted(config.password()), config.domain(), config.proxyHost(), config.proxyPort(), config.proxyUsername(), PasswordEncrypter.getInstance().ensureDecrypted(config.proxyPassword()))));
        }
        catch (Exception e) {
            throw new TemplateVersioningException("Unable to initialize git client with current settings", (Throwable)e, TemplateVersioningException$.MODULE$.apply$default$3());
        }
    }
}

