package com.xebialabs.xlrelease.plugin.git;

import java.util.Collection;
import org.eclipse.jgit.api.Git;
import org.eclipse.jgit.api.LsRemoteCommand;
import org.eclipse.jgit.api.errors.GitAPIException;
import org.eclipse.jgit.lib.Ref;
import org.eclipse.jgit.transport.UsernamePasswordCredentialsProvider;
import com.google.common.base.Strings;

import static java.lang.String.format;
import static org.eclipse.jgit.lib.Constants.HEAD;
import static org.eclipse.jgit.lib.Constants.R_HEADS;

public class GitClient {
    private String root;
    private String branch;
    private String userName;
    private String password;

    public GitClient(String root, String branch, String userName, String password) {
        this.root = root;
        this.branch = branch;
        this.userName = userName;
        this.password = password;
    }

    public String getLatestRevision() throws GitAPIException {
        Collection<Ref> refs = fetchRemoteReferences();

        return !Strings.isNullOrEmpty(branch) ? findBranchSha1(refs, branch) : findDefaultBranchSha1(refs);
    }

    private Collection<Ref> fetchRemoteReferences() throws GitAPIException {
        LsRemoteCommand lsRemoteCommand = Git.lsRemoteRepository().setRemote(root).setTags(false);

        if (userName != null && password != null) {
            lsRemoteCommand.setCredentialsProvider(new UsernamePasswordCredentialsProvider(userName, password));
        }

        return lsRemoteCommand.call();
    }

    private String findBranchSha1(Collection<Ref> refs, String branch) {
        return findSha1(refs, R_HEADS + branch);
    }

    private String findDefaultBranchSha1(Collection<Ref> refs) {
        return findSha1(refs, HEAD);
    }

    private String findSha1(Collection<Ref> refs, String input) {
        for (Ref ref : refs) {
            if (ref.getName().equals(input)) {
                return ref.getObjectId().getName();
            }
        }
        throw new IllegalArgumentException(format("'%s' not found on %s", input, root));
    }
}
