#
# Copyright 2020 XEBIALABS
#
# Permission is hereby granted, free of charge, to any person obtaining a copy of this software and associated documentation files (the "Software"), to deal in the Software without restriction, including without limitation the rights to use, copy, modify, merge, publish, distribute, sublicense, and/or sell copies of the Software, and to permit persons to whom the Software is furnished to do so, subject to the following conditions:
#
# The above copyright notice and this permission notice shall be included in all copies or substantial portions of the Software.
#
# THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE SOFTWARE.
#

import json
from actions.GithubRestClient import GithubRestClient

githubRestClient = GithubRestClient(server, loginOrToken, password)

if not triggered:
    body = {
            "ref": ref,
            "inputs": inputs
        }
    githubRestClient.createDispatchEvent(repositoryName, workflowIdFilename, body)
    triggerStatus = "Success"
    if wait:
        triggered = True
        task.setStatusLine("Triggered...")
        task.schedule("actions/TriggerWorkflowRun.py", 3)

elif runIdScript is None and triggered:
    response = githubRestClient.getWorkflowRunsList(repositoryName)
    runIdScript = str(response["workflow_runs"][0]["id"])
    task.schedule("actions/TriggerWorkflowRun.py", 3)

elif runIdScript is not None and triggered:
    response = githubRestClient.getWorkflowRunDetails(repositoryName, runIdScript)
    status = response["status"]
    if status == "completed":
        runId = runIdScript
        conclusion = response["conclusion"]
        html_url = response["html_url"]
        if conclusion == "success":
            task.setStatusLine(status.title())
            print(
                "GitHub Actions [workflow run {}]({}) conclusion: {}".format(
                    runIdScript, html_url, conclusion.title()
                )
            )
        else:
            task.setStatusLine(status.title())
            raise Exception(
                "GitHub Actions [workflow run {}]({}) conclusion: {}".format(
                    runIdScript, html_url, conclusion.title()
                )
            )
    else:
        task.setStatusLine(status.title().replace("_", " ") + "...")
        task.schedule("actions/TriggerWorkflowRun.py", 3)
