package com.xebialabs.xlrelease.webhooks.github

import com.xebialabs.deployit.plugin.api.udm.{Metadata, Property}
import com.xebialabs.xlplatform.webhooks.authentication.RequestAuthenticationMethod
import com.xebialabs.xlrelease.webhooks.authentication.BaseRequestAuthentication

import scala.beans.BeanProperty

@Metadata(label = "Github Authentication")
class GithubAuthentication extends BaseRequestAuthentication {
  @BeanProperty
  @Property(label = "Github Webhook Secret", password = true, required = true, description = "Secret token as defined on the Github Webhook configuration page")
  var githubSecret: String = _

  def requestAuthentication: RequestAuthenticationMethod = GithubAuthenticationMethod
}