# Copyright (c) 2021. All rights reserved.
#
# This software and all trademarks, trade names, and logos included herein are the property of XebiaLabs, Inc. and its affiliates, subsidiaries, and licensors.

import json
from gitlab.Client import Client
from java.time import LocalDate, ZonedDateTime


def convertRFC3339ToDate(timestamp):
    zonedDateTime = ZonedDateTime.parse(timestamp)
    return zonedDateTime.toLocalDate()

if gitlab_server is None or project_id is None or results_limit is None:
    data = {}
else:
    client = Client()
    tags = json.loads(client.gitlab_querytags(locals())["tags"])

    # Compile data for summary view
    tagsByDay = {}
    tagNamesByDay = {}
    for tag in tags:
        tagDate = convertRFC3339ToDate(tag["commit"]["committed_date"])
        if tagDate in tagsByDay.keys():
            tagsByDay[tagDate] += 1
            tagNamesByDay[tagDate] = tagNamesByDay[tagDate] + ", " + tag["name"]
        else:
            tagsByDay[tagDate] = 1
            tagNamesByDay[tagDate] = tag["name"]

    if len(tagsByDay) == 0:
        raise Exception("No tags found for ")

    dates = [date for date in tagsByDay.keys()]
    dates.sort()
    startDate = dates[0]
    endDate = dates[-1]
    days = []
    tagsEachDay = []
    tagNamesEachDay = []
    daysWithTags = [dayTags.toString() for dayTags in tagsByDay.keys()]
    while startDate.isBefore(endDate.plusDays(1)):
        days.append(startDate.toString())
        if startDate.toString() in daysWithTags:
            tagsEachDay.append(tagsByDay[startDate])
            tagNamesEachDay.append(tagNamesByDay[startDate])
        else:
            tagsEachDay.append(0)
            tagNamesEachDay.append("None")
        startDate = startDate.plusDays(1)

    data = {
        "dates": days,
        "tagsEachDay": tagsEachDay,
        "tagNamesEachDay": tagNamesEachDay,
        "tags": tags,
    }
