#
# Copyright (c) 2018. All rights reserved.
#
# This software and all trademarks, trade names, and logos included herein are the property of XebiaLabs, Inc. and its affiliates, subsidiaries, and licensors.
#
from kubernetes.yaml_parser import YamlParser

updates = {}

manifestPath = task.pythonScript.getProperty('manifestPath')

appnameUpdates = task.pythonScript.getProperty('appnameUpdates')
if appnameUpdates:
    for old_app_name in appnameUpdates:
        path = "metadata{name~%s}/name" % old_app_name
        updates[path] = appnameUpdates[old_app_name]

imageUpdates = task.pythonScript.getProperty('imageUpdates')
if imageUpdates:
    for container_name in imageUpdates:
        path = "spec/template/spec/containers{name~%s}/image" % container_name
        updates[path] = imageUpdates[container_name]

customUpdates = task.pythonScript.getProperty('customUpdates')
for update in customUpdates:
    updates[update] = customUpdates[update]

yamlObjects = YamlParser(manifestPath).replaceValue(updates)
