#
# Copyright (c) 2018. All rights reserved.
#
# This software and all trademarks, trade names, and logos included herein are the property of XebiaLabs, Inc. and its affiliates, subsidiaries, and licensors.
#

class CommandHelper:

    @staticmethod
    def commandParams(configuration, flags):
        context = configuration['context']
        if context:
            flags.append('--context')
            flags.append(context)

        server = configuration['server']
        if server:
            flags.append('--server')
            flags.append(server)

        certificateAuthority = configuration['certificateAuthority']
        if certificateAuthority:
            flags.append('--certificate-authority')
            flags.append(certificateAuthority)

        clientCertificate = configuration['clientCertificate']
        if clientCertificate:
            flags.append('--client-certificate')
            flags.append(clientCertificate)

        clientKey = configuration['clientKey']
        if clientKey:
            flags.append('--client-key')
            flags.append(clientKey)

        token = configuration['token']
        if token:
            flags.append('--token')
            flags.append(token)

        insecureSkipTlsVerify = configuration['insecureSkipTlsVerify']
        if insecureSkipTlsVerify:
            flags.append('--insecure-skip-tls-verify')

        namespace = configuration['namespace']
        if namespace:
            flags.append('--namespace')
            flags.append(namespace)

        kubeconfig = configuration['configPath']
        if kubeconfig:
            flags.append('--kubeconfig')
            flags.append(kubeconfig)

        otherParams = configuration['params']
        if otherParams:
            flags.append(otherParams)

        return flags

