from openshift.api_client import APIClient
import time

client = APIClient(task.pythonScript.getProperty("host"), task.pythonScript.getProperty('ocPath'))

output = client.execute_openshift_command(
    command="{} {}".format(task.pythonScript.getProperty('command'), task.pythonScript.getProperty('buildConfName')),
    cmd_params=task.pythonScript.getProperty('cmdParams')).stdout

build_id = output.split('"')[1]

build_pass = False
for count in range(0, task.pythonScript.getProperty('retryCount')):
    APIClient.add_comment("Retry count {}".format(count + 1))

    output = client.execute_openshift_command(
        command="{} {}".format('describe bc', task.pythonScript.getProperty('buildConfName'))).stdout
    output = output.replace('\t', '').replace(' ', '')

    if '{}complete'.format(build_id) in output:
        APIClient.add_comment('{} is completed successfully.'.format(build_id))
        build_pass = True
        break;

    time.sleep(5)

if not build_pass:
    raise RuntimeError("Build {} is not successful in given time frame.".format(build_id))
