#
# Copyright (c) 2018. All rights reserved.
#
# This software and all trademarks, trade names, and logos included herein are the property of XebiaLabs, Inc. and its affiliates, subsidiaries, and licensors.
#

import time
import re
from openshift.api_client import APIClient

if not task.pythonScript.getProperty('spec')  and not task.pythonScript.getProperty('url'):
    raise Exception('No source for input file (inline|URL) is provided')
elif task.pythonScript.getProperty('spec')  and task.pythonScript.getProperty('url'):
    raise Exception('Please provide only one source for input file(inline|url)')

client = APIClient(task.pythonScript.getProperty("client"))

match=True
try:
    spec = task.pythonScript.getProperty('spec')
    if not spec:
        spec = APIClient.download_file(task.pythonScript.getProperty('url'),task.pythonScript.getProperty('username'),task.pythonScript.getProperty('password'))

    response = client.execute_openshift_spec(spec,task.pythonScript.getProperty('command'),task.pythonScript.getProperty('cmdParams'))

    command=task.pythonScript.getProperty('waitCommand')
    pattern=task.pythonScript.getProperty('pattern')
    if command and pattern:
        wait_in_sec=task.pythonScript.getProperty('waitInSeconds')
        retry_count=task.pythonScript.getProperty('waitRetryCount')

        match=False
        for num in range(0,retry_count):
            response = client.execute_openshift_command(command =command, process_exit=False)
            output = response.stdout
            error = response.stderr
            if re.search(pattern,output,re.M):
                match=True
                break
            time.sleep(wait_in_sec)
finally:
    client.logout()

if not match:
    raise Exception('Expression not found in command output')
