/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.xlrelease.plugin.openshift;

import com.xebialabs.deployit.plugin.api.reflect.PropertyDescriptor;
import com.xebialabs.deployit.plugin.api.udm.ConfigurationItem;
import com.xebialabs.overthere.CmdLine;
import com.xebialabs.overthere.ConnectionOptions;
import com.xebialabs.overthere.OperatingSystemFamily;
import com.xebialabs.overthere.Overthere;
import com.xebialabs.overthere.OverthereConnection;
import com.xebialabs.overthere.OverthereExecutionOutputHandler;
import com.xebialabs.overthere.OverthereFile;
import com.xebialabs.overthere.ssh.SshConnectionType;
import com.xebialabs.overthere.util.CapturingOverthereExecutionOutputHandler;
import com.xebialabs.overthere.util.OverthereUtils;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.io.Writer;
import java.nio.charset.StandardCharsets;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RemoteScript {
    private static final String SCRIPT_NAME = "uploaded-script";
    private final ConnectionOptions options = new ConnectionOptions();
    private final String protocol;
    private final String extension;
    private CapturingOverthereExecutionOutputHandler stdout = CapturingOverthereExecutionOutputHandler.capturingHandler();
    private CapturingOverthereExecutionOutputHandler stderr = CapturingOverthereExecutionOutputHandler.capturingHandler();
    private static Logger logger = LoggerFactory.getLogger(RemoteScript.class);

    public RemoteScript(ConfigurationItem remoteScript) {
        this.protocol = (String)remoteScript.getProperty("protocol");
        this.copyPropertiesToConnectionOptions(this.options, remoteScript);
        this.extension = ((OperatingSystemFamily)this.options.get("os", (Object)OperatingSystemFamily.UNIX)).getScriptExtension();
    }

    private void copyPropertiesToConnectionOptions(ConnectionOptions options, ConfigurationItem ci) {
        if (ci.hasProperty("sudo") && ((Boolean)ci.getProperty("sudo")).booleanValue()) {
            ci.setProperty("connectionType", (Object)SshConnectionType.SUDO);
            ci.setProperty("sudoUsername", (Object)"root");
        }
        for (PropertyDescriptor pd : ci.getType().getDescriptor().getPropertyDescriptors()) {
            if (pd.getCategory().equals("output")) continue;
            Object value = pd.get(ci);
            this.setConnectionOption(options, pd.getName(), value);
        }
    }

    private void setConnectionOption(ConnectionOptions options, String key, Object value) {
        if (key.equals("script") || key.equals("remotePath") || key.equals("scriptLocation")) {
            return;
        }
        if (value == null || value.toString().isEmpty()) {
            return;
        }
        if (key.equals("temporaryDirectoryPath")) {
            key = "tmp";
        } else if (key.equals("timeout")) {
            key = "winrmTimeout";
        }
        if (value instanceof Integer && (Integer)value == 0) {
            logger.debug("Activating workaround for DEPLOYITPB-4775: Integer with value of 0 not passed to Overthere.");
            return;
        }
        if (key.equals("jumpstation")) {
            ConfigurationItem item = (ConfigurationItem)value;
            ConnectionOptions jumpstationOptions = new ConnectionOptions();
            this.copyPropertiesToConnectionOptions(jumpstationOptions, item);
            options.set(key, (Object)jumpstationOptions);
        } else {
            options.set(key, value);
        }
    }

    public CmdResponse executeOpenshiftSpec(String spec, String script) {
        int rc;
        try (OverthereConnection connection = Overthere.getConnection((String)this.protocol, (ConnectionOptions)this.options);){
            OverthereFile specFile = connection.getTempFile("spec", ".spec");
            OverthereUtils.write((byte[])spec.getBytes(StandardCharsets.UTF_8), (OverthereFile)specFile);
            script = script + specFile.getPath();
            rc = this.executeScript(script, connection);
        }
        catch (Exception e) {
            this.publishErrorStackTrace(e);
            rc = 1;
        }
        return new CmdResponse(rc, this.stdout.getOutput(), this.stderr.getOutput());
    }

    public CmdResponse executeScript(String script) {
        int rc;
        try (OverthereConnection connection = Overthere.getConnection((String)this.protocol, (ConnectionOptions)this.options);){
            rc = this.executeScript(script, connection);
        }
        catch (Exception e) {
            this.publishErrorStackTrace(e);
            rc = 1;
        }
        return new CmdResponse(rc, this.stdout.getOutput(), this.stderr.getOutput());
    }

    private void publishErrorStackTrace(Exception exception) {
        StringWriter stacktrace = new StringWriter();
        PrintWriter writer = new PrintWriter((Writer)stacktrace, true);
        exception.printStackTrace(writer);
        this.stderr.handleLine(stacktrace.toString());
    }

    private int executeScript(String script, OverthereConnection connection) {
        OverthereFile targetFile = connection.getTempFile(SCRIPT_NAME, this.extension);
        OverthereUtils.write((byte[])script.getBytes(StandardCharsets.UTF_8), (OverthereFile)targetFile);
        targetFile.setExecutable(true);
        CmdLine scriptCommand = CmdLine.build((String[])new String[]{targetFile.getPath()});
        return connection.execute((OverthereExecutionOutputHandler)this.stdout, (OverthereExecutionOutputHandler)this.stderr, scriptCommand);
    }

    public String getTimeFileName(String prefix, String suffix) {
        OverthereConnection connection = Overthere.getConnection((String)this.protocol, (ConnectionOptions)this.options);
        OverthereFile specFile = connection.getTempFile(prefix, suffix);
        return specFile.getPath();
    }

    public String getStdout() {
        return this.stdout.getOutput();
    }

    public List<String> getStdoutLines() {
        return this.stdout.getOutputLines();
    }

    public String getStderr() {
        return this.stderr.getOutput();
    }

    public List<String> getStderrLines() {
        return this.stderr.getOutputLines();
    }

    public void cleanOutputHandlers() {
        this.stderr = CapturingOverthereExecutionOutputHandler.capturingHandler();
        this.stdout = CapturingOverthereExecutionOutputHandler.capturingHandler();
    }

    public class CmdResponse {
        public int rc;
        public String stdout;
        public String stderr;

        public CmdResponse(int rc, String stdout, String stderr) {
            this.rc = rc;
            this.stdout = stdout;
            this.stderr = stderr;
        }
    }
}

