/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.xlrelease.plugins.remotecompletion.email;

import com.xebialabs.xlrelease.configuration.UserProfile;
import com.xebialabs.xlrelease.domain.Task;
import com.xebialabs.xlrelease.domain.Team;
import com.xebialabs.xlrelease.plugins.remotecompletion.ci.ImapServer;
import com.xebialabs.xlrelease.service.TeamService;
import com.xebialabs.xlrelease.service.UserProfileService;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class EmailAddressService {
    private final TeamService teamService;
    private final UserProfileService userProfileService;

    @Autowired
    public EmailAddressService(TeamService teamService, UserProfileService userProfileService) {
        this.teamService = teamService;
        this.userProfileService = userProfileService;
    }

    public Map<String, String> getEmailAddressesFromTask(Task task) {
        HashMap<String, String> assignees = new HashMap<String, String>();
        this.getNotificationEmailOf(task.getOwner()).ifPresent(s -> assignees.put((String)s, task.getOwner()));
        Optional.ofNullable(task.getTeam()).flatMap(t -> this.teamService.findTeamByName(task.getRelease().getId(), t).map(Team::getMembers)).orElse(Collections.emptyList()).forEach(member -> this.getNotificationEmailOf((String)member).ifPresent(email -> assignees.put((String)email, (String)member)));
        return assignees;
    }

    public boolean emailIsWhitelisted(String fromEmail, ImapServer imapServer) {
        if (imapServer.isWhitelistEnabled()) {
            List<String> whitelist = imapServer.getWhitelist();
            return whitelist.stream().anyMatch(fromEmail::endsWith);
        }
        return true;
    }

    public Optional<String> getNotificationEmailOf(String username) {
        return Optional.ofNullable(username).filter(u -> !u.isEmpty()).map(arg_0 -> ((UserProfileService)this.userProfileService).discover(arg_0)).filter(UserProfile::isLoginAllowed).map(UserProfile::getEmail);
    }
}

