package com.xebialabs.xlrelease.plugin.overthere;

import com.xebialabs.overthere.ConnectionOptions;
import com.xebialabs.overthere.OperatingSystemFamily;
import com.xebialabs.overthere.ssh.SshConnectionBuilder;
import com.xebialabs.overthere.ssh.SshConnectionType;

public class SshRemoteScript extends RemoteScript {

    private final boolean sudo;

    public SshRemoteScript(String username, String password, boolean sudo, String address, String remotePath, String script) {
        super(OperatingSystemFamily.UNIX, SshConnectionBuilder.SSH_PROTOCOL,
                username, password, address, remotePath, script);
        this.sudo = sudo;
    }

    @Override
    protected void customize(ConnectionOptions options) {
        if (sudo) {
            options.set(SshConnectionBuilder.CONNECTION_TYPE, SshConnectionType.SUDO);
            options.set(SshConnectionBuilder.SUDO_USERNAME, "root");
        } else {
            options.set(SshConnectionBuilder.CONNECTION_TYPE, SshConnectionType.SCP);
        }
    }
}
