/*
 * Decompiled with CFR 0.152.
 */
package org.tmatesoft.svn.core.internal.util;

import java.io.IOException;
import java.io.InputStream;

public class FixedSizeInputStream
extends InputStream {
    private long myLength;
    private InputStream mySource;

    public FixedSizeInputStream(InputStream source, long length) {
        this.mySource = source;
        this.myLength = length;
    }

    @Override
    public int read() throws IOException {
        int read = -1;
        if (this.myLength > 0L && (read = this.mySource.read()) != -1) {
            --this.myLength;
        }
        return read;
    }

    @Override
    public int read(byte[] b, int off, int len) throws IOException {
        if (this.myLength <= 0L) {
            return -1;
        }
        if (b == null) {
            throw new NullPointerException();
        }
        if (off < 0 || off > b.length || len < 0 || off + len > b.length || off + len < 0) {
            throw new IndexOutOfBoundsException();
        }
        if (len == 0) {
            return 0;
        }
        long toRead = Math.min(this.myLength, (long)len);
        if ((toRead = (long)this.mySource.read(b, off, (int)toRead)) >= 0L) {
            this.myLength -= toRead;
        }
        return (int)toRead;
    }

    @Override
    public void close() {
        if (this.myLength > 0L) {
            try {
                FixedSizeInputStream.consumeRemaining(this);
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }

    static void consumeRemaining(InputStream is) throws IOException {
        byte[] buffer = new byte[1024];
        while (is.read(buffer) >= 0) {
        }
    }
}

