/*
 * Decompiled with CFR 0.152.
 */
package org.tmatesoft.svn.core.internal.io.dav.handlers;

import java.io.UnsupportedEncodingException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import org.tmatesoft.svn.core.SVNException;
import org.tmatesoft.svn.core.SVNLock;
import org.tmatesoft.svn.core.internal.io.dav.DAVElement;
import org.tmatesoft.svn.core.internal.io.dav.handlers.BasicDAVHandler;
import org.tmatesoft.svn.core.internal.util.SVNBase64;
import org.tmatesoft.svn.core.internal.util.SVNDate;
import org.tmatesoft.svn.core.internal.util.SVNXMLUtil;
import org.xml.sax.Attributes;

public class DAVGetLocksHandler
extends BasicDAVHandler {
    private static final String LOCK_COMMENT_SUFFIX = "</ns0:owner>";
    private static final String LOCK_COMMENT_PREFIX = "<ns0:owner xmlns:ns0=\"DAV:\">";
    private static final String EMPTY_LOCK_COMMENT = "<ns0:owner xmlns:ns0=\"DAV:\"/>";
    private Collection myLocks = new ArrayList();
    private String myPath;
    private String myToken;
    private String myComment;
    private String myOwner;
    private Date myExpirationDate;
    private Date myCreationDate;
    private boolean myIsBase64;

    public static StringBuffer generateGetLocksRequest(StringBuffer xmlBuffer) {
        xmlBuffer = xmlBuffer == null ? new StringBuffer() : xmlBuffer;
        SVNXMLUtil.addXMLHeader(xmlBuffer);
        SVNXMLUtil.openNamespaceDeclarationTag("S", "get-locks-report", SVN_DAV_NAMESPACES_LIST, SVNXMLUtil.PREFIX_MAP, xmlBuffer);
        SVNXMLUtil.addXMLFooter("S", "get-locks-report", xmlBuffer);
        return xmlBuffer;
    }

    public DAVGetLocksHandler() {
        this.init();
    }

    public SVNLock[] getLocks() {
        return this.myLocks.toArray(new SVNLock[this.myLocks.size()]);
    }

    @Override
    protected void startElement(DAVElement parent, DAVElement element, Attributes attrs) throws SVNException {
        this.myIsBase64 = false;
        if (attrs != null) {
            this.myIsBase64 = "base64".equals(attrs.getValue("encoding"));
        }
    }

    @Override
    protected void endElement(DAVElement parent, DAVElement element, StringBuffer cdata) throws SVNException {
        if (element == DAVElement.SVN_LOCK) {
            if (this.myPath != null && this.myToken != null) {
                SVNLock lock = new SVNLock(this.myPath, this.myToken, this.myOwner, this.myComment, this.myCreationDate, this.myExpirationDate);
                this.myLocks.add(lock);
            }
            this.myPath = null;
            this.myOwner = null;
            this.myToken = null;
            this.myComment = null;
            this.myCreationDate = null;
            this.myExpirationDate = null;
        } else if (element == DAVElement.SVN_LOCK_PATH && cdata != null) {
            this.myPath = cdata.toString();
        } else if (element == DAVElement.SVN_LOCK_TOKEN && cdata != null) {
            this.myToken = cdata.toString();
        } else if (element == DAVElement.SVN_LOCK_OWNER && cdata != null) {
            this.myOwner = cdata.toString();
            if (this.myIsBase64) {
                StringBuffer sb = SVNBase64.normalizeBase64(new StringBuffer(this.myOwner));
                byte[] buffer = this.allocateBuffer(sb.length());
                int length = SVNBase64.base64ToByteArray(sb, buffer);
                try {
                    this.myOwner = new String(buffer, 0, length, "UTF-8");
                }
                catch (UnsupportedEncodingException e) {
                    this.myOwner = new String(buffer, 0, length);
                }
            }
        } else if (element == DAVElement.SVN_LOCK_COMMENT && cdata != null) {
            this.myComment = cdata.toString();
            if (this.myComment != null && this.myComment.trim().startsWith(LOCK_COMMENT_PREFIX) && this.myComment.trim().endsWith(LOCK_COMMENT_SUFFIX)) {
                this.myComment = this.myComment.trim().substring(LOCK_COMMENT_PREFIX.length(), this.myComment.trim().length() - LOCK_COMMENT_SUFFIX.length());
            } else if (this.myComment.trim().equals(EMPTY_LOCK_COMMENT)) {
                this.myComment = "";
            }
            if (this.myIsBase64) {
                StringBuffer sb = SVNBase64.normalizeBase64(new StringBuffer(this.myComment));
                byte[] buffer = this.allocateBuffer(sb.length());
                int length = SVNBase64.base64ToByteArray(sb, buffer);
                try {
                    this.myComment = new String(buffer, 0, length, "UTF-8");
                }
                catch (UnsupportedEncodingException e) {
                    this.myComment = new String(buffer, 0, length);
                }
            }
        } else if (element == DAVElement.SVN_LOCK_CREATION_DATE && cdata != null) {
            this.myCreationDate = SVNDate.parseDate(cdata.toString());
        } else if (element == DAVElement.SVN_LOCK_EXPIRATION_DATE && cdata != null) {
            this.myExpirationDate = SVNDate.parseDate(cdata.toString());
        }
        this.myIsBase64 = false;
    }
}

