/*
 * Decompiled with CFR 0.152.
 */
package org.tmatesoft.svn.core.internal.io.dav.http;

import java.io.UnsupportedEncodingException;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.security.InvalidKeyException;
import java.security.NoSuchAlgorithmException;
import java.util.Map;
import java.util.TreeMap;
import javax.crypto.BadPaddingException;
import javax.crypto.Cipher;
import javax.crypto.IllegalBlockSizeException;
import javax.crypto.NoSuchPaddingException;
import javax.crypto.spec.SecretKeySpec;
import org.tmatesoft.svn.core.SVNErrorCode;
import org.tmatesoft.svn.core.SVNErrorMessage;
import org.tmatesoft.svn.core.SVNException;
import org.tmatesoft.svn.core.internal.io.dav.http.HTTPAuthentication;
import org.tmatesoft.svn.core.internal.util.SVNBase64;
import org.tmatesoft.svn.core.internal.util.SVNFormatUtil;
import org.tmatesoft.svn.core.internal.wc.SVNErrorManager;
import org.tmatesoft.svn.util.SVNLogType;

class HTTPNTLMAuthentication
extends HTTPAuthentication {
    private static final String NTLM_CASE_CONVERTION_PROPERTY = "svnkit.http.ntlm.uppercase";
    private static final String OLD_NTLM_CASE_CONVERTION_PROPERTY = "javasvn.http.ntlm.uppercase";
    private static final String DEFAULT_CHARSET = "ASCII";
    private static final String PROTOCOL_NAME = "NTLMSSP";
    private static final int LM_RESPONSE_LENGTH = 24;
    private static final int UNINITIATED = 0;
    protected static final int TYPE1 = 1;
    protected static final int TYPE3 = 3;
    private static byte[] ourMagicBytes = new byte[]{75, 71, 83, 33, 64, 35, 36, 37};
    private static final long NEGOTIATE_UNICODE = 1L;
    private static final long NEGOTIATE_OEM = 2L;
    private static final long REQUEST_TARGET = 4L;
    private static final long NEGOTIATE_SIGN = 16L;
    private static final long NEGOTIATE_SEAL = 32L;
    private static final long NEGOTIATE_DATAGRAM_STYLE = 64L;
    private static final long NEGOTIATE_LAN_MANAGER_KEY = 128L;
    private static final long NEGOTIATE_NETWARE = 256L;
    private static final long NEGOTIATE_NTLM = 512L;
    private static final long NEGOTIATE_DOMAIN_SUPPLIED = 4096L;
    private static final long NEGOTIATE_WORKSTATION_SUPPLIED = 8192L;
    private static final long NEGOTIATE_LOCAL_CALL = 16384L;
    private static final long NEGOTIATE_ALWAYS_SIGN = 32768L;
    private static final long TARGET_TYPE_DOMAIN = 65536L;
    private static final long TARGET_TYPE_SERVER = 131072L;
    private static final long TARGET_TYPE_SHARE = 262144L;
    private static final long NEGOTIATE_NTLM2_KEY = 524288L;
    private static final long REQUEST_INIT_RESPONSE = 0x100000L;
    private static final long REQUEST_ACCEPT_RESPONSE = 0x200000L;
    private static final long REQUEST_NON_NT_SESSION_KEY = 0x400000L;
    private static final long NEGOTIATE_TARGET_INFO = 0x800000L;
    private static final long NEGOTIATE_128 = 0x20000000L;
    private static final long NEGOTIATE_KEY_EXCHANGE = 0x40000000L;
    private static final long NEGOTIATE_56 = 0x80000000L;
    private static Map<Long, String> ourFlags = new TreeMap<Long, String>();
    private static Map<Integer, String> ourTargetInfoTypes;
    protected int myState = 0;
    private String myCharset;
    private byte[] myResponse;
    private int myPosition;
    private byte[] myNonce;
    private boolean myIsNegotiateLocalCall = false;

    protected HTTPNTLMAuthentication(String charset) {
        this.myCharset = charset;
        if (this.myCharset == null) {
            this.myCharset = "US-ASCII";
        }
    }

    public void setType1State() {
        this.myState = 1;
    }

    public void setType3State() {
        this.myState = 3;
    }

    public boolean isInType3State() {
        return this.myState == 3;
    }

    private void initResponse(int bufferSize) {
        this.myResponse = new byte[bufferSize];
        this.myPosition = 0;
    }

    private void addByte(byte b) {
        this.myResponse[this.myPosition++] = b;
    }

    private void addBytes(byte[] bytes) {
        for (int i = 0; i < bytes.length; ++i) {
            this.myResponse[this.myPosition++] = bytes[i];
        }
    }

    private byte[] convertToShortValue(int num) {
        byte[] val = new byte[]{(byte)(num & 0xFF), (byte)(num >> 8 & 0xFF)};
        return val;
    }

    private String getResponse() {
        byte[] response;
        if (this.myResponse.length > this.myPosition) {
            response = new byte[this.myPosition];
            for (int i = 0; i < this.myPosition; ++i) {
                response[i] = this.myResponse[i];
            }
        } else {
            response = this.myResponse;
        }
        return SVNBase64.byteArrayToBase64(response);
    }

    public void parseChallenge(String challenge) throws SVNException {
        int i;
        String base64DecodedMessage;
        SVNErrorMessage err;
        String proto;
        if (challenge == null) {
            SVNErrorMessage err2 = SVNErrorMessage.create(SVNErrorCode.RA_DAV_REQUEST_FAILED, "NTLM HTTP auth: expected challenge");
            SVNErrorManager.error(err2, SVNLogType.NETWORK);
        }
        byte[] challengeBase64Bytes = HTTPAuthentication.getBytes(challenge, DEFAULT_CHARSET);
        byte[] resultBuffer = new byte[challengeBase64Bytes.length];
        int resultLength = 0;
        try {
            resultLength = SVNBase64.base64ToByteArray(new StringBuffer(new String(challengeBase64Bytes, this.myCharset)), resultBuffer);
        }
        catch (UnsupportedEncodingException e) {
            SVNErrorMessage err3 = SVNErrorMessage.create(SVNErrorCode.RA_DAV_REQUEST_FAILED, "NTLM HTTP auth: " + e.getMessage());
            SVNErrorManager.error(err3, SVNLogType.NETWORK);
        }
        try {
            proto = new String(resultBuffer, 0, 7, this.myCharset);
        }
        catch (UnsupportedEncodingException e) {
            proto = new String(resultBuffer, 0, 7);
        }
        byte[] typeBytes = new byte[4];
        for (int i2 = 0; i2 < 4; ++i2) {
            typeBytes[i2] = resultBuffer[8 + i2];
        }
        long type = this.toLong(typeBytes);
        if (!PROTOCOL_NAME.equalsIgnoreCase(proto)) {
            err = SVNErrorMessage.create(SVNErrorCode.RA_DAV_REQUEST_FAILED, "NTLM HTTP auth: incorrect signature ''(0}''", (Object)proto);
            SVNErrorManager.error(err, SVNLogType.NETWORK);
        } else if (type != 2L) {
            err = SVNErrorMessage.create(SVNErrorCode.RA_DAV_REQUEST_FAILED, "NTLM HTTP auth: expected type 2 message instead of ''(0, number, integer}''", (Object)type);
            SVNErrorManager.error(err, SVNLogType.NETWORK);
        }
        this.myNonce = new byte[8];
        for (int i3 = 0; i3 < 8; ++i3) {
            this.myNonce[i3] = resultBuffer[i3 + 24];
        }
        byte[] flagBytes = new byte[4];
        for (int i4 = 0; i4 < 4; ++i4) {
            flagBytes[i4] = resultBuffer[i4 + 20];
        }
        long flags = this.toLong(flagBytes);
        StringBuffer log = new StringBuffer();
        try {
            base64DecodedMessage = new String(resultBuffer, 0, resultLength, this.myCharset);
        }
        catch (UnsupportedEncodingException e) {
            base64DecodedMessage = new String(resultBuffer, 0, resultLength);
        }
        log.append("NTLM auth message: " + base64DecodedMessage);
        log.append('\n');
        log.append("Length: " + base64DecodedMessage.length());
        log.append('\n');
        log.append("Signature: " + proto);
        log.append('\n');
        log.append("Type: " + type);
        log.append('\n');
        log.append("Flags: " + Long.toString(flags, 16));
        log.append('\n');
        for (Long curFlag : ourFlags.keySet()) {
            if ((flags & curFlag) == 0L) continue;
            log.append(ourFlags.get(curFlag));
            log.append('\n');
        }
        byte[] targetNameLengthBytes = new byte[2];
        for (int i5 = 0; i5 < 2; ++i5) {
            targetNameLengthBytes[i5] = resultBuffer[12 + i5];
        }
        int targetNameLength = HTTPNTLMAuthentication.toInt(targetNameLengthBytes);
        byte[] targetNameAllocatedBytes = new byte[2];
        for (int i6 = 0; i6 < 2; ++i6) {
            targetNameAllocatedBytes[i6] = resultBuffer[14 + i6];
        }
        int targetNameAllocated = HTTPNTLMAuthentication.toInt(targetNameAllocatedBytes);
        byte[] targetNameOffsetBytes = new byte[4];
        for (int i7 = 0; i7 < 4; ++i7) {
            targetNameOffsetBytes[i7] = resultBuffer[16 + i7];
        }
        long targetNameOffset = this.toLong(targetNameOffsetBytes);
        if (targetNameLength > 0) {
            String targetName;
            try {
                targetName = new String(resultBuffer, (int)targetNameOffset, targetNameAllocated, this.myCharset);
            }
            catch (UnsupportedEncodingException e) {
                targetName = new String(resultBuffer, (int)targetNameOffset, targetNameAllocated);
            }
            log.append("Target Name: " + targetName);
            log.append('\n');
        }
        log.append("Challenge: ");
        for (int i8 = 0; i8 < this.myNonce.length; ++i8) {
            log.append(SVNFormatUtil.getHexNumberFromByte(this.myNonce[i8]));
        }
        log.append('\n');
        long contextH = -1L;
        long contextL = -1L;
        boolean containsContext = false;
        if (targetNameOffset != 32L && resultLength >= 40) {
            byte[] contextHBytes = new byte[4];
            byte[] contextLBytes = new byte[4];
            i = 0;
            for (i = 0; i < 4; ++i) {
                contextHBytes[i] = resultBuffer[i + 32];
            }
            while (i < 8) {
                contextLBytes[i - 4] = resultBuffer[i + 32];
                ++i;
            }
            contextH = this.toLong(contextHBytes);
            contextL = this.toLong(contextLBytes);
            if (contextL == 0L) {
                containsContext = true;
                log.append("Context: ");
                log.append(Long.toString(contextH, 16) + " " + Long.toString(contextL, 16));
                log.append('\n');
            }
            this.myIsNegotiateLocalCall = contextH != 0L && (flags & 0x4000L) != 0L;
        } else {
            this.myIsNegotiateLocalCall = false;
        }
        if ((flags & 0x800000L) != 0L) {
            int tgtInfoSecurityBufferOffset = containsContext ? 40 : 32;
            byte[] targetInfoLengthBytes = new byte[2];
            for (i = 0; i < 2; ++i) {
                targetInfoLengthBytes[i] = resultBuffer[tgtInfoSecurityBufferOffset + i];
            }
            int targetInfoLength = HTTPNTLMAuthentication.toInt(targetInfoLengthBytes);
            byte[] targetInfoAllocatedBytes = new byte[2];
            for (int i9 = 0; i9 < 2; ++i9) {
                targetInfoAllocatedBytes[i9] = resultBuffer[tgtInfoSecurityBufferOffset + 2 + i9];
            }
            int targetInfoAllocated = HTTPNTLMAuthentication.toInt(targetInfoAllocatedBytes);
            byte[] targetInfoOffsetBytes = new byte[4];
            for (int i10 = 0; i10 < 4; ++i10) {
                targetInfoOffsetBytes[i10] = resultBuffer[tgtInfoSecurityBufferOffset + 4 + i10];
            }
            long targetInfoOffset = this.toLong(targetInfoOffsetBytes);
            byte[] targetInfoTypeBytes = new byte[2];
            byte[] subblockLengthBytes = new byte[2];
            int read = 0;
            while (targetInfoLength > 0 && read <= targetInfoAllocated) {
                for (int i11 = 0; i11 < 2; ++i11) {
                    targetInfoTypeBytes[i11] = resultBuffer[(int)targetInfoOffset + i11];
                }
                read += 2;
                targetInfoOffset += 2L;
                int targetInfoType = HTTPNTLMAuthentication.toInt(targetInfoTypeBytes);
                if (targetInfoType == 0) break;
                for (int i12 = 0; i12 < 2; ++i12) {
                    subblockLengthBytes[i12] = resultBuffer[(int)targetInfoOffset + i12];
                }
                read += 2;
                targetInfoOffset += 2L;
                int subblockLength = HTTPNTLMAuthentication.toInt(subblockLengthBytes);
                String typeDescription = ourTargetInfoTypes.get(targetInfoType);
                if (typeDescription != null) {
                    String info;
                    try {
                        info = new String(resultBuffer, (int)targetInfoOffset, subblockLength, this.myCharset);
                    }
                    catch (UnsupportedEncodingException e) {
                        info = new String(resultBuffer, (int)targetInfoOffset, subblockLength);
                    }
                    log.append(typeDescription + ": " + info);
                    log.append('\n');
                }
                read += subblockLength;
                targetInfoOffset += (long)subblockLength;
            }
        }
        log.append('\n');
    }

    private static int toInt(byte[] num) {
        int l = 0;
        for (int i = 0; i < 2; ++i) {
            int b = num[i] & 0xFF;
            l |= (b <<= i * 8);
        }
        return l;
    }

    @Override
    public String authenticate() throws SVNException {
        if (this.myState != 1 && this.myState != 3) {
            SVNErrorMessage err = SVNErrorMessage.create(SVNErrorCode.RA_DAV_REQUEST_FAILED, "Unsupported message type in HTTP NTLM authentication");
            SVNErrorManager.error(err, SVNLogType.NETWORK);
        }
        String username = this.getUserName();
        String domain = this.getDomain();
        if (domain == null) {
            domain = "";
        }
        String hostName = null;
        try {
            InetAddress localhost = InetAddress.getLocalHost();
            hostName = localhost.getHostName();
        }
        catch (UnknownHostException uhe) {
            hostName = "";
        }
        if (this.isUpperCase()) {
            domain = domain.toUpperCase();
            hostName = hostName.toUpperCase();
        }
        byte[] protocol = HTTPAuthentication.getBytes(PROTOCOL_NAME, DEFAULT_CHARSET);
        byte[] domainBytes = HTTPAuthentication.getBytes(domain, DEFAULT_CHARSET);
        byte[] hostNameBytes = HTTPAuthentication.getBytes(hostName, DEFAULT_CHARSET);
        byte[] domLen = this.convertToShortValue(domainBytes.length);
        byte[] hostLen = this.convertToShortValue(hostNameBytes.length);
        StringBuffer sublog = new StringBuffer();
        sublog.append("Signature: NTLMSSP");
        sublog.append('\n');
        long flags = 16902L;
        if (domain.length() > 0) {
            flags |= 0x1000L;
        }
        if (this.myState == 1) {
            int responseLength = 32 + domainBytes.length + hostNameBytes.length;
            this.initResponse(responseLength);
            this.addBytes(protocol);
            this.addByte((byte)0);
            this.addByte((byte)1);
            this.addByte((byte)0);
            this.addByte((byte)0);
            this.addByte((byte)0);
            sublog.append("Type: 1");
            sublog.append('\n');
            this.addByte((byte)(flags & 0xFFL));
            this.addByte((byte)(flags >> 8 & 0xFFL));
            this.addByte((byte)(flags >> 16 & 0xFFL));
            this.addByte((byte)(flags >> 24 & 0xFFL));
            sublog.append("Flags: " + Long.toString(flags, 16));
            sublog.append('\n');
            for (Long curFlag : ourFlags.keySet()) {
                if ((flags & curFlag) == 0L) continue;
                sublog.append(ourFlags.get(curFlag));
                sublog.append('\n');
            }
            this.addBytes(domLen);
            this.addBytes(domLen);
            byte[] domainOffset = this.convertToShortValue(hostNameBytes.length + 32);
            this.addBytes(domainOffset);
            this.addByte((byte)0);
            this.addByte((byte)0);
            this.addBytes(hostLen);
            this.addBytes(hostLen);
            byte[] hostOffset = this.convertToShortValue(32);
            this.addBytes(hostOffset);
            this.addByte((byte)0);
            this.addByte((byte)0);
            this.addBytes(hostNameBytes);
            if (hostName.length() > 0) {
                sublog.append("Host Name: " + hostName);
                sublog.append('\n');
            }
            this.addBytes(domainBytes);
            if (domain.length() > 0) {
                sublog.append("Domain: " + domain);
                sublog.append('\n');
            }
        } else if (this.myState == 3) {
            int responseLength;
            byte[] userBytes = username.getBytes();
            sublog.append("Type: 3");
            sublog.append('\n');
            sublog.append("Flags: " + Long.toString(flags, 16));
            sublog.append('\n');
            for (Long curFlag : ourFlags.keySet()) {
                if ((flags & curFlag) == 0L) continue;
                sublog.append(ourFlags.get(curFlag));
                sublog.append('\n');
            }
            if (!this.myIsNegotiateLocalCall) {
                char[] password;
                responseLength = 88 + domainBytes.length + hostNameBytes.length + userBytes.length;
                this.initResponse(responseLength);
                this.addBytes(protocol);
                this.addByte((byte)0);
                this.addByte((byte)3);
                this.addByte((byte)0);
                this.addByte((byte)0);
                this.addByte((byte)0);
                byte[] lmResponseLength = this.convertToShortValue(24);
                this.addBytes(lmResponseLength);
                this.addBytes(lmResponseLength);
                this.addBytes(this.convertToShortValue(responseLength - 24));
                this.addByte((byte)0);
                this.addByte((byte)0);
                byte[] ntlmResponseLength = this.convertToShortValue(0);
                this.addBytes(ntlmResponseLength);
                this.addBytes(ntlmResponseLength);
                byte[] responseLengthShortBytes = this.convertToShortValue(responseLength);
                this.addBytes(responseLengthShortBytes);
                this.addByte((byte)0);
                this.addByte((byte)0);
                this.addBytes(domLen);
                this.addBytes(domLen);
                this.addBytes(this.convertToShortValue(64));
                this.addByte((byte)0);
                this.addByte((byte)0);
                byte[] usernameLength = this.convertToShortValue(userBytes.length);
                this.addBytes(usernameLength);
                this.addBytes(usernameLength);
                this.addBytes(this.convertToShortValue(64 + domainBytes.length));
                this.addByte((byte)0);
                this.addByte((byte)0);
                this.addBytes(hostLen);
                this.addBytes(hostLen);
                this.addBytes(this.convertToShortValue(64 + domainBytes.length + userBytes.length));
                for (int i = 0; i < 6; ++i) {
                    this.addByte((byte)0);
                }
                this.addBytes(responseLengthShortBytes);
                this.addByte((byte)0);
                this.addByte((byte)0);
                this.addByte((byte)(flags & 0xFFL));
                this.addByte((byte)(flags >> 8 & 0xFFL));
                this.addByte((byte)(flags >> 16 & 0xFFL));
                this.addByte((byte)(flags >> 24 & 0xFFL));
                this.addBytes(domainBytes);
                if (domain.length() > 0) {
                    sublog.append("Domain: " + domain);
                    sublog.append('\n');
                }
                this.addBytes(userBytes);
                if (username.length() > 0) {
                    sublog.append("User Name: " + username);
                    sublog.append('\n');
                }
                this.addBytes(hostNameBytes);
                if (hostName.length() > 0) {
                    sublog.append("Host Name: " + hostName);
                    sublog.append('\n');
                }
                byte[] hash = this.hashPassword((password = this.getPassword()) != null ? password : new char[]{});
                this.addBytes(hash);
                sublog.append("Hash: " + new String(hash));
                sublog.append('\n');
            } else {
                responseLength = 64;
                byte[] responseLengthShortBytes = this.convertToShortValue(responseLength);
                this.initResponse(responseLength);
                this.addBytes(protocol);
                this.addByte((byte)0);
                this.addByte((byte)3);
                this.addByte((byte)0);
                this.addByte((byte)0);
                this.addByte((byte)0);
                this.addByte((byte)0);
                this.addByte((byte)0);
                this.addByte((byte)0);
                this.addByte((byte)0);
                this.addBytes(responseLengthShortBytes);
                this.addByte((byte)0);
                this.addByte((byte)0);
                this.addByte((byte)0);
                this.addByte((byte)0);
                this.addByte((byte)0);
                this.addByte((byte)0);
                this.addBytes(responseLengthShortBytes);
                this.addByte((byte)0);
                this.addByte((byte)0);
                this.addByte((byte)0);
                this.addByte((byte)0);
                this.addByte((byte)0);
                this.addByte((byte)0);
                this.addBytes(responseLengthShortBytes);
                this.addByte((byte)0);
                this.addByte((byte)0);
                this.addByte((byte)0);
                this.addByte((byte)0);
                this.addByte((byte)0);
                this.addByte((byte)0);
                this.addBytes(responseLengthShortBytes);
                this.addByte((byte)0);
                this.addByte((byte)0);
                this.addByte((byte)0);
                this.addByte((byte)0);
                this.addByte((byte)0);
                this.addByte((byte)0);
                this.addBytes(responseLengthShortBytes);
                for (int i = 0; i < 6; ++i) {
                    this.addByte((byte)0);
                }
                this.addBytes(responseLengthShortBytes);
                this.addByte((byte)0);
                this.addByte((byte)0);
                this.addByte((byte)(flags & 0xFFL));
                this.addByte((byte)(flags >> 8 & 0xFFL));
                this.addByte((byte)(flags >> 16 & 0xFFL));
                this.addByte((byte)(flags >> 24 & 0xFFL));
            }
            this.setType1State();
        }
        StringBuffer log = new StringBuffer();
        String message = null;
        try {
            message = new String(this.myResponse, 0, this.myPosition, this.myCharset);
        }
        catch (UnsupportedEncodingException e) {
            message = new String(this.myResponse, 0, this.myPosition);
        }
        log.append("NTLM auth message: " + message);
        log.append('\n');
        log.append("Length: " + message.length());
        log.append('\n');
        log.append(sublog);
        return "NTLM " + this.getResponse();
    }

    @Override
    public String getAuthenticationScheme() {
        return "NTLM";
    }

    public boolean isNative() {
        return false;
    }

    @Override
    public String getUserName() {
        int slashInd;
        String login = this.getRawUserName();
        String userName = null;
        int n = slashInd = login != null ? login.indexOf(92) : -1;
        if (slashInd != -1) {
            int lastInd;
            for (lastInd = slashInd + 1; lastInd < login.length() && login.charAt(lastInd) == '\\'; ++lastInd) {
            }
            userName = login.substring(lastInd);
        } else {
            userName = login == null ? System.getProperty("user.name") : login;
        }
        return userName;
    }

    public String getDomain() {
        int slashInd;
        String login = this.getRawUserName();
        String domain = null;
        int n = slashInd = login != null ? login.indexOf(92) : -1;
        if (slashInd != -1) {
            domain = login.substring(0, slashInd);
        }
        return domain;
    }

    private long toLong(byte[] num) {
        long l = 0L;
        for (int i = 0; i < 4; ++i) {
            long b = num[i] & 0xFF;
            l |= (b <<= i * 8);
        }
        return l;
    }

    private boolean isUpperCase() {
        String upperCase = System.getProperty(NTLM_CASE_CONVERTION_PROPERTY, System.getProperty(OLD_NTLM_CASE_CONVERTION_PROPERTY, "true"));
        return Boolean.valueOf(upperCase);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private byte[] hashPassword(char[] password) throws SVNException {
        char[] upperCasePassword = new char[password.length];
        System.arraycopy(password, 0, upperCasePassword, 0, password.length);
        if (this.isUpperCase()) {
            for (int i = 0; i < upperCasePassword.length; ++i) {
                upperCasePassword[i] = Character.toUpperCase(password[i]);
            }
        }
        byte[] passw = HTTPAuthentication.getBytes(upperCasePassword, "US-ASCII");
        try {
            int i;
            int idx;
            byte[] lmPw1 = new byte[7];
            byte[] lmPw2 = new byte[7];
            int len = passw.length;
            if (len > 7) {
                len = 7;
            }
            for (idx = 0; idx < len; ++idx) {
                lmPw1[idx] = passw[idx];
            }
            while (idx < 7) {
                lmPw1[idx] = 0;
                ++idx;
            }
            len = passw.length;
            if (len > 14) {
                len = 14;
            }
            for (idx = 7; idx < len; ++idx) {
                lmPw2[idx - 7] = passw[idx];
            }
            while (idx < 14) {
                lmPw2[idx - 7] = 0;
                ++idx;
            }
            byte[] lmHpw1 = this.encrypt(lmPw1, ourMagicBytes);
            byte[] lmHpw2 = this.encrypt(lmPw2, ourMagicBytes);
            byte[] lmHpw = new byte[21];
            for (i = 0; i < lmHpw1.length; ++i) {
                lmHpw[i] = lmHpw1[i];
            }
            for (i = 0; i < lmHpw2.length; ++i) {
                lmHpw[i + 8] = lmHpw2[i];
            }
            for (i = 0; i < 5; ++i) {
                lmHpw[i + 16] = 0;
            }
            byte[] lmResp = new byte[24];
            this.calcResp(lmHpw, lmResp);
            byte[] byArray = lmResp;
            return byArray;
        }
        finally {
            HTTPAuthentication.clear(upperCasePassword);
            HTTPAuthentication.clear(passw);
        }
    }

    private void calcResp(byte[] keys, byte[] results) throws SVNException {
        int i;
        int i2;
        byte[] keys1 = new byte[7];
        byte[] keys2 = new byte[7];
        byte[] keys3 = new byte[7];
        for (i2 = 0; i2 < 7; ++i2) {
            keys1[i2] = keys[i2];
        }
        for (i2 = 0; i2 < 7; ++i2) {
            keys2[i2] = keys[i2 + 7];
        }
        for (i2 = 0; i2 < 7; ++i2) {
            keys3[i2] = keys[i2 + 14];
        }
        byte[] results1 = this.encrypt(keys1, this.myNonce);
        byte[] results2 = this.encrypt(keys2, this.myNonce);
        byte[] results3 = this.encrypt(keys3, this.myNonce);
        for (i = 0; i < 8; ++i) {
            results[i] = results1[i];
        }
        for (i = 0; i < 8; ++i) {
            results[i + 8] = results2[i];
        }
        for (i = 0; i < 8; ++i) {
            results[i + 16] = results3[i];
        }
    }

    private byte[] encrypt(byte[] key, byte[] bytes) throws SVNException {
        Cipher ecipher = this.getCipher(key);
        try {
            byte[] enc = ecipher.doFinal(bytes);
            return enc;
        }
        catch (IllegalBlockSizeException e) {
            SVNErrorMessage err = SVNErrorMessage.create(SVNErrorCode.IO_ERROR, "Invalid block size for DES encryption: {0}", (Object)e.getLocalizedMessage());
            SVNErrorManager.error(err, SVNLogType.NETWORK);
        }
        catch (BadPaddingException e) {
            SVNErrorMessage err = SVNErrorMessage.create(SVNErrorCode.IO_ERROR, "Data not padded correctly for DES encryption: {0}", (Object)e.getLocalizedMessage());
            SVNErrorManager.error(err, SVNLogType.NETWORK);
        }
        return null;
    }

    private Cipher getCipher(byte[] key) throws SVNException {
        try {
            Cipher ecipher = Cipher.getInstance("DES/ECB/NoPadding");
            key = this.setupKey(key);
            ecipher.init(1, new SecretKeySpec(key, "DES"));
            return ecipher;
        }
        catch (NoSuchAlgorithmException e) {
            SVNErrorMessage err = SVNErrorMessage.create(SVNErrorCode.IO_ERROR, "DES encryption is not available: {0}", (Object)e.getLocalizedMessage());
            SVNErrorManager.error(err, SVNLogType.NETWORK);
        }
        catch (InvalidKeyException e) {
            SVNErrorMessage err = SVNErrorMessage.create(SVNErrorCode.IO_ERROR, "Invalid key for DES encryption: {0}", (Object)e.getLocalizedMessage());
            SVNErrorManager.error(err, SVNLogType.NETWORK);
        }
        catch (NoSuchPaddingException e) {
            SVNErrorMessage err = SVNErrorMessage.create(SVNErrorCode.IO_ERROR, "NoPadding option for DES is not available: {0}", (Object)e.getLocalizedMessage());
            SVNErrorManager.error(err, SVNLogType.NETWORK);
        }
        return null;
    }

    private byte[] setupKey(byte[] key56) {
        byte[] key = new byte[]{(byte)(key56[0] >> 1 & 0xFF), (byte)(((key56[0] & 1) << 6 | (key56[1] & 0xFF) >> 2 & 0xFF) & 0xFF), (byte)(((key56[1] & 3) << 5 | (key56[2] & 0xFF) >> 3 & 0xFF) & 0xFF), (byte)(((key56[2] & 7) << 4 | (key56[3] & 0xFF) >> 4 & 0xFF) & 0xFF), (byte)(((key56[3] & 0xF) << 3 | (key56[4] & 0xFF) >> 5 & 0xFF) & 0xFF), (byte)(((key56[4] & 0x1F) << 2 | (key56[5] & 0xFF) >> 6 & 0xFF) & 0xFF), (byte)(((key56[5] & 0x3F) << 1 | (key56[6] & 0xFF) >> 7 & 0xFF) & 0xFF), (byte)(key56[6] & 0x7F)};
        for (int i = 0; i < key.length; ++i) {
            key[i] = (byte)(key[i] << 1);
        }
        return key;
    }

    public boolean allowPropmtForCredentials() {
        return true;
    }

    static {
        ourFlags.put(1L, "0x00000001 (Negotiate Unicode)");
        ourFlags.put(2L, "0x00000002 (Negotiate OEM)");
        ourFlags.put(4L, "0x00000004 (Request Target)");
        ourFlags.put(8L, "0x00000008 (Unknown)");
        ourFlags.put(16L, "0x00000010 (Negotiate Sign)");
        ourFlags.put(32L, "0x00000020 (Negotiate Seal)");
        ourFlags.put(64L, "0x00000040 (Negotiate Datagram Style)");
        ourFlags.put(128L, "0x00000080 (Negotiate Lan Manager Key)");
        ourFlags.put(256L, "0x00000100 (Negotiate Netware)");
        ourFlags.put(512L, "0x00000200 (Negotiate NTLM)");
        ourFlags.put(1024L, "0x00000400 (Unknown)");
        ourFlags.put(2048L, "0x00000800 (Unknown)");
        ourFlags.put(4096L, "0x00001000 (Negotiate Domain Supplied)");
        ourFlags.put(8192L, "0x00002000 (Negotiate Workstation Supplied)");
        ourFlags.put(16384L, "0x00004000 (Negotiate Local Call)");
        ourFlags.put(32768L, "0x00008000 (Negotiate Always Sign)");
        ourFlags.put(65536L, "0x00010000 (Target Type Domain)");
        ourFlags.put(131072L, "0x00020000 (Target Type Server)");
        ourFlags.put(262144L, "0x00040000 (Target Type Share)");
        ourFlags.put(524288L, "0x00080000 (Negotiate NTLM2 Key)");
        ourFlags.put(0x100000L, "0x00100000 (Request Init Response)");
        ourFlags.put(0x200000L, "0x00200000 (Request Accept Response)");
        ourFlags.put(0x400000L, "0x00400000 (Request Non-NT Session Key)");
        ourFlags.put(0x800000L, "0x00800000 (Negotiate Target Info)");
        ourFlags.put(0x1000000L, "0x01000000 (Unknown)");
        ourFlags.put(0x2000000L, "0x02000000 (Unknown)");
        ourFlags.put(0x4000000L, "0x04000000 (Unknown)");
        ourFlags.put(0x8000000L, "0x08000000 (Unknown)");
        ourFlags.put(0x10000000L, "0x10000000 (Unknown)");
        ourFlags.put(0x20000000L, "0x20000000 (Negotiate 128)");
        ourFlags.put(0x40000000L, "0x40000000 (Negotiate Key Exchange)");
        ourFlags.put(0x80000000L, "0x80000000 (Negotiate 56)");
        ourTargetInfoTypes = new TreeMap<Integer, String>();
        ourTargetInfoTypes.put(1, "Server Name");
        ourTargetInfoTypes.put(2, "Domain Name");
        ourTargetInfoTypes.put(3, "DNS Host Name");
        ourTargetInfoTypes.put(4, "DNS Domain Name");
    }
}

