/*
 * Decompiled with CFR 0.152.
 */
package org.tmatesoft.svn.core.internal.io.fs.index;

import java.io.EOFException;
import java.io.File;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.util.logging.Level;
import org.tmatesoft.svn.core.SVNErrorCode;
import org.tmatesoft.svn.core.SVNErrorMessage;
import org.tmatesoft.svn.core.SVNException;
import org.tmatesoft.svn.core.internal.io.fs.FSFS;
import org.tmatesoft.svn.core.internal.io.fs.FSRepositoryUtil;
import org.tmatesoft.svn.core.internal.io.fs.index.FSP2LEntry;
import org.tmatesoft.svn.core.internal.wc.SVNErrorManager;
import org.tmatesoft.svn.core.internal.wc.SVNFileUtil;
import org.tmatesoft.svn.util.SVNDebugLog;
import org.tmatesoft.svn.util.SVNLogType;

public class FSP2LProtoIndex {
    private static final long MAX_OFFSET = Integer.MAX_VALUE;
    private static final String FILENAME = "index.p2l";
    private final RandomAccessFile file;

    public static FSP2LProtoIndex open(FSFS fsfs, String txnId, boolean append) throws SVNException {
        try {
            RandomAccessFile randomAccessFile = new RandomAccessFile(FSP2LProtoIndex.getIndexPath(fsfs, txnId), "rw");
            if (append) {
                randomAccessFile.seek(randomAccessFile.length());
            }
            return new FSP2LProtoIndex(randomAccessFile);
        }
        catch (IOException e) {
            SVNErrorMessage errorMessage = SVNErrorMessage.create(SVNErrorCode.IO_ERROR, e);
            SVNErrorManager.error(errorMessage, SVNLogType.FSFS);
            return null;
        }
    }

    public static File getIndexPath(FSFS fsfs, String txnId) {
        File transactionDir = fsfs.getTransactionDir(txnId);
        return SVNFileUtil.createFilePath(transactionDir, FILENAME);
    }

    public FSP2LProtoIndex(RandomAccessFile file) {
        this.file = file;
    }

    public void close() {
        try {
            this.file.close();
        }
        catch (IOException e) {
            SVNDebugLog.getDefaultLog().log(SVNLogType.FSFS, e, Level.INFO);
        }
    }

    public FSP2LEntry readEntry() throws SVNException {
        boolean eof;
        long offset = this.readOffset();
        long size = this.readOffset();
        int type = this.readInt();
        long fnv1Checksum = this.readLong();
        long revision = this.readLong();
        long itemNumber = this.readLong();
        boolean bl = eof = offset < 0L || size < 0L || type < 0 || fnv1Checksum < 0L || revision < 0L || itemNumber < 0L;
        if (!eof) {
            if (revision > 0L && revision - 1L > Long.MAX_VALUE) {
                SVNErrorMessage errorMessage = SVNErrorMessage.create(SVNErrorCode.FS_INDEX_OVERFLOW, "Revision 0x{0} too large, max = 0x{1}", Long.toHexString(revision), Long.toHexString(Integer.MAX_VALUE));
                SVNErrorManager.error(errorMessage, SVNLogType.FSFS);
            }
            long itemRevision = revision == 0L ? -1L : revision - 1L;
            return new FSP2LEntry(offset, size, ItemType.fromCode(type), (int)fnv1Checksum, itemRevision, itemNumber);
        }
        return null;
    }

    public void writeEntry(FSP2LEntry entry) throws SVNException {
        assert (entry.getOffset() >= 0L);
        assert (entry.getSize() >= 0L);
        assert (entry.getRevision() >= 0L || entry.getRevision() == -1L);
        long revision = entry.getRevision() == -1L ? 0L : entry.getRevision() + 1L;
        try {
            FSRepositoryUtil.writeLongLittleEndian(this.file, entry.getOffset());
            FSRepositoryUtil.writeLongLittleEndian(this.file, entry.getSize());
            FSRepositoryUtil.writeLongLittleEndian(this.file, entry.getType().getCode());
            FSRepositoryUtil.writeLongLittleEndian(this.file, (long)entry.getChecksum() & 0xFFFFFFFFL);
            FSRepositoryUtil.writeLongLittleEndian(this.file, revision);
            FSRepositoryUtil.writeLongLittleEndian(this.file, entry.getNumber());
        }
        catch (IOException e) {
            SVNErrorMessage errorMessage = SVNErrorMessage.create(SVNErrorCode.IO_ERROR, e);
            SVNErrorManager.error(errorMessage, SVNLogType.FSFS);
        }
    }

    public long readNextOffset() throws SVNException {
        try {
            long offset = this.file.getFilePointer();
            if (offset == 0L) {
                return 0L;
            }
            this.file.seek(offset -= 48L);
            FSP2LEntry entry = this.readEntry();
            return entry.getOffset() + entry.getSize();
        }
        catch (IOException e) {
            SVNErrorMessage errorMessage = SVNErrorMessage.create(SVNErrorCode.IO_ERROR, e);
            SVNErrorManager.error(errorMessage, SVNLogType.FSFS);
            return -1L;
        }
    }

    private int readInt() throws SVNException {
        long value = this.readLong();
        if (value >= 0L && value > Integer.MAX_VALUE) {
            SVNErrorMessage errorMessage = SVNErrorMessage.create(SVNErrorCode.FS_INDEX_OVERFLOW, "UINT32 0x{0} too large, max = 0x{1}", Long.toHexString(value), Long.toHexString(Integer.MAX_VALUE));
            SVNErrorManager.error(errorMessage, SVNLogType.FSFS);
        }
        return (int)value;
    }

    private long readOffset() throws SVNException {
        long offset = this.readLong();
        if (offset >= 0L && offset > Integer.MAX_VALUE) {
            SVNErrorMessage errorMessage = SVNErrorMessage.create(SVNErrorCode.FS_INDEX_OVERFLOW, "File offset 0x{0} too large, max = 0x{1}", Long.toHexString(offset), Long.toHexString(Integer.MAX_VALUE));
            SVNErrorManager.error(errorMessage, SVNLogType.FSFS);
        }
        return offset;
    }

    private long readLong() throws SVNException {
        try {
            return FSRepositoryUtil.readLongLittleEndian(this.file);
        }
        catch (EOFException e) {
            return -1L;
        }
        catch (IOException e) {
            SVNErrorMessage errorMessage = SVNErrorMessage.create(SVNErrorCode.IO_ERROR, e);
            SVNErrorManager.error(errorMessage, SVNLogType.FSFS);
            return -1L;
        }
    }

    public static enum ItemType {
        UNUSED(0),
        FILE_REP(1),
        DIR_REP(2),
        FILE_PROPS(3),
        DIR_PROPS(4),
        NODEREV(5),
        CHANGES(6);

        private final int code;

        public static ItemType fromCode(int code) {
            ItemType[] values;
            for (ItemType itemType : values = ItemType.values()) {
                if (itemType.getCode() != code) continue;
                return itemType;
            }
            return null;
        }

        private ItemType(int code) {
            this.code = code;
        }

        public int getCode() {
            return this.code;
        }
    }
}

