/*
 * Decompiled with CFR 0.152.
 */
package org.tmatesoft.svn.core.internal.wc.admin;

import java.util.Collections;
import java.util.Map;
import java.util.Set;
import org.tmatesoft.svn.core.SVNDepth;
import org.tmatesoft.svn.core.internal.util.SVNHashMap;
import org.tmatesoft.svn.core.internal.util.SVNHashSet;
import org.tmatesoft.svn.core.internal.wc.admin.SVNAdminArea;
import org.tmatesoft.svn.core.internal.wc.admin.SVNWCAccess;

public class SVNAdminAreaInfo {
    private String myTargetName;
    private SVNAdminArea myTarget;
    private SVNAdminArea myAnchor;
    private SVNWCAccess myAccess;
    private Map myNewExternals;
    private Map myOldExternals;
    private Map myDepths;
    private Set myIncompleteEntries;
    private boolean myIsEnableIncompleteTrick;

    public SVNAdminAreaInfo(SVNWCAccess access, SVNAdminArea anchor, SVNAdminArea target, String targetName) {
        this.myAccess = access;
        this.myAnchor = anchor;
        this.myTarget = target;
        this.myTargetName = targetName;
        this.myIsEnableIncompleteTrick = false;
    }

    public SVNAdminArea getAnchor() {
        return this.myAnchor;
    }

    public SVNAdminArea getTarget() {
        return this.myTarget;
    }

    public void setTarget(SVNAdminArea target) {
        this.myTarget = target;
    }

    public void setAnchor(SVNAdminArea anchor) {
        this.myAnchor = anchor;
    }

    public String getTargetName() {
        return this.myTargetName;
    }

    public SVNWCAccess getWCAccess() {
        return this.myAccess;
    }

    public void setWCAccess(SVNWCAccess wcAccess) {
        this.myAccess = wcAccess;
    }

    public void addOldExternal(String path, String oldValue) {
        if (this.myOldExternals == null) {
            this.myOldExternals = new SVNHashMap();
        }
        this.myOldExternals.put(path, oldValue);
    }

    public void addNewExternal(String path, String newValue) {
        if (this.myNewExternals == null) {
            this.myNewExternals = new SVNHashMap();
        }
        this.myNewExternals.put(path, newValue);
    }

    public void addExternal(String path, String oldValue, String newValue) {
        this.addNewExternal(path, newValue);
        this.addOldExternal(path, oldValue);
    }

    public void addDepth(String path, SVNDepth depth) {
        if (this.myDepths == null) {
            this.myDepths = new SVNHashMap();
        }
        this.myDepths.put(path, depth);
    }

    public void removeDepth(String path) {
        if (this.myDepths != null) {
            this.myDepths.remove(path);
        }
    }

    public void removeExternal(String path) {
        if (this.myNewExternals != null) {
            this.myNewExternals.remove(path);
        }
        if (this.myOldExternals != null) {
            this.myOldExternals.remove(path);
        }
    }

    public Map getNewExternals() {
        return this.myNewExternals == null ? Collections.EMPTY_MAP : this.myNewExternals;
    }

    public Map getOldExternals() {
        return this.myOldExternals == null ? Collections.EMPTY_MAP : this.myOldExternals;
    }

    public Map getDepths() {
        return this.myDepths == null ? Collections.EMPTY_MAP : this.myDepths;
    }

    public void addIncompleteEntry(String path) {
        if (!this.myIsEnableIncompleteTrick) {
            return;
        }
        if (this.myIncompleteEntries == null) {
            this.myIncompleteEntries = new SVNHashSet();
        }
        this.myIncompleteEntries.add(path);
    }

    public boolean isIncomplete(String path) {
        if (!this.myIsEnableIncompleteTrick) {
            return false;
        }
        return this.myIncompleteEntries != null && this.myIncompleteEntries.contains(path);
    }
}

