/*
 * Decompiled with CFR 0.152.
 */
package org.tmatesoft.svn.core.wc;

import org.tmatesoft.svn.core.ISVNCanceller;
import org.tmatesoft.svn.core.SVNException;
import org.tmatesoft.svn.core.SVNURL;
import org.tmatesoft.svn.core.auth.ISVNAuthenticationManager;
import org.tmatesoft.svn.core.internal.wc.DefaultSVNOptions;
import org.tmatesoft.svn.core.io.SVNRepository;
import org.tmatesoft.svn.core.io.SVNRepositoryFactory;
import org.tmatesoft.svn.core.wc.DefaultSVNRepositoryPool;
import org.tmatesoft.svn.core.wc.ISVNEventHandler;
import org.tmatesoft.svn.core.wc.ISVNOptions;
import org.tmatesoft.svn.core.wc.ISVNRepositoryPool;
import org.tmatesoft.svn.core.wc.SVNBasicClient;
import org.tmatesoft.svn.core.wc.SVNChangelistClient;
import org.tmatesoft.svn.core.wc.SVNCommitClient;
import org.tmatesoft.svn.core.wc.SVNCopyClient;
import org.tmatesoft.svn.core.wc.SVNDiffClient;
import org.tmatesoft.svn.core.wc.SVNLogClient;
import org.tmatesoft.svn.core.wc.SVNMoveClient;
import org.tmatesoft.svn.core.wc.SVNStatusClient;
import org.tmatesoft.svn.core.wc.SVNUpdateClient;
import org.tmatesoft.svn.core.wc.SVNWCClient;
import org.tmatesoft.svn.core.wc.SVNWCUtil;
import org.tmatesoft.svn.core.wc.admin.SVNAdminBasicClient;
import org.tmatesoft.svn.core.wc.admin.SVNAdminClient;
import org.tmatesoft.svn.core.wc.admin.SVNLookClient;
import org.tmatesoft.svn.core.wc2.SvnOperationFactory;
import org.tmatesoft.svn.util.ISVNDebugLog;
import org.tmatesoft.svn.util.SVNDebugLog;

public class SVNClientManager
implements ISVNRepositoryPool {
    private ISVNOptions myOptions;
    private SVNCommitClient myCommitClient;
    private SVNCopyClient myCopyClient;
    private SVNDiffClient myDiffClient;
    private SVNLogClient myLogClient;
    private SVNMoveClient myMoveClient;
    private SVNStatusClient myStatusClient;
    private SVNUpdateClient myUpdateClient;
    private SVNWCClient myWCClient;
    private SVNChangelistClient myChangelistClient;
    private SVNAdminClient myAdminClient;
    private SVNLookClient myLookClient;
    private ISVNEventHandler myEventHandler;
    private ISVNRepositoryPool myRepositoryPool;
    private ISVNDebugLog myDebugLog;
    private SvnOperationFactory myOperationFactory;
    private boolean myIsIgnoreExternals;

    private SVNClientManager(ISVNOptions options, ISVNRepositoryPool repositoryPool) {
        this.myOptions = options;
        if (this.myOptions == null) {
            this.myOptions = SVNWCUtil.createDefaultOptions(true);
        }
        this.myRepositoryPool = repositoryPool;
    }

    private SVNClientManager(ISVNOptions options, ISVNAuthenticationManager authManager) {
        this(options, new DefaultSVNRepositoryPool(authManager == null ? SVNWCUtil.createDefaultAuthenticationManager() : authManager, options));
    }

    private SVNClientManager(SvnOperationFactory of) {
        this.myOperationFactory = of;
    }

    public static SVNClientManager newInstance() {
        return new SVNClientManager(null, (ISVNAuthenticationManager)null);
    }

    public static SVNClientManager newInstance(ISVNOptions options) {
        return new SVNClientManager(options, (ISVNAuthenticationManager)null);
    }

    public static SVNClientManager newInstance(ISVNOptions options, ISVNAuthenticationManager authManager) {
        return new SVNClientManager(options, authManager);
    }

    public static SVNClientManager newInstance(SvnOperationFactory operationFactory) {
        return new SVNClientManager(operationFactory);
    }

    public static SVNClientManager newInstance(ISVNOptions options, ISVNRepositoryPool repositoryPool) {
        return new SVNClientManager(options, repositoryPool);
    }

    public static SVNClientManager newInstance(DefaultSVNOptions options, String userName, String password) {
        boolean storeAuth = options == null || options.isAuthStorageEnabled();
        ISVNAuthenticationManager authManager = SVNWCUtil.createDefaultAuthenticationManager(null, userName, password, storeAuth);
        return new SVNClientManager((ISVNOptions)options, authManager);
    }

    @Override
    public SVNRepository createRepository(SVNURL url, boolean mayReuse) throws SVNException {
        if (this.getRepositoryPool() != null) {
            return this.getRepositoryPool().createRepository(url, mayReuse);
        }
        SVNRepository repository = SVNRepositoryFactory.create(url);
        repository.setAuthenticationManager(SVNWCUtil.createDefaultAuthenticationManager());
        repository.setDebugLog(this.getDebugLog());
        return repository;
    }

    @Override
    public void shutdownConnections(boolean shutdownAll) {
        if (this.getRepositoryPool() != null) {
            this.getRepositoryPool().dispose();
        }
    }

    @Override
    public void dispose() {
        if (this.myOperationFactory != null) {
            this.myOperationFactory.dispose();
        } else if (this.myRepositoryPool != null) {
            this.myRepositoryPool.dispose();
        }
    }

    public ISVNOptions getOptions() {
        if (this.myOperationFactory != null) {
            return this.myOperationFactory.getOptions();
        }
        return this.myOptions;
    }

    public void setEventHandler(ISVNEventHandler handler) {
        this.myEventHandler = handler;
        this.setCanceller(handler);
        if (this.myCommitClient != null) {
            this.myCommitClient.setEventHandler(handler);
        }
        if (this.myCopyClient != null) {
            this.myCopyClient.setEventHandler(handler);
        }
        if (this.myDiffClient != null) {
            this.myDiffClient.setEventHandler(handler);
        }
        if (this.myLogClient != null) {
            this.myLogClient.setEventHandler(handler);
        }
        if (this.myMoveClient != null) {
            this.myMoveClient.setEventHandler(handler);
        }
        if (this.myStatusClient != null) {
            this.myStatusClient.setEventHandler(handler);
        }
        if (this.myUpdateClient != null) {
            this.myUpdateClient.setEventHandler(handler);
        }
        if (this.myWCClient != null) {
            this.myWCClient.setEventHandler(handler);
        }
        if (this.myChangelistClient != null) {
            this.myChangelistClient.setEventHandler(handler);
        }
        if (this.myAdminClient != null) {
            this.myAdminClient.setEventHandler(handler);
        }
        if (this.myLookClient != null) {
            this.myLookClient.setEventHandler(handler);
        }
    }

    public void setIgnoreExternals(boolean isIgnoreExternals) {
        this.myIsIgnoreExternals = isIgnoreExternals;
        if (this.myCommitClient != null) {
            this.myCommitClient.setIgnoreExternals(this.myIsIgnoreExternals);
        }
        if (this.myCopyClient != null) {
            this.myCopyClient.setIgnoreExternals(this.myIsIgnoreExternals);
        }
        if (this.myDiffClient != null) {
            this.myDiffClient.setIgnoreExternals(this.myIsIgnoreExternals);
        }
        if (this.myLogClient != null) {
            this.myLogClient.setIgnoreExternals(this.myIsIgnoreExternals);
        }
        if (this.myMoveClient != null) {
            this.myMoveClient.setIgnoreExternals(this.myIsIgnoreExternals);
        }
        if (this.myStatusClient != null) {
            this.myStatusClient.setIgnoreExternals(this.myIsIgnoreExternals);
        }
        if (this.myUpdateClient != null) {
            this.myUpdateClient.setIgnoreExternals(this.myIsIgnoreExternals);
        }
        if (this.myWCClient != null) {
            this.myWCClient.setIgnoreExternals(this.myIsIgnoreExternals);
        }
        if (this.myChangelistClient != null) {
            this.myChangelistClient.setIgnoreExternals(this.myIsIgnoreExternals);
        }
    }

    public boolean isIgnoreExternals() {
        return this.myIsIgnoreExternals;
    }

    public void setOptions(ISVNOptions options) {
        if (this.myOperationFactory != null) {
            this.myOperationFactory.setOptions(options);
        } else {
            this.myOptions = options;
            if (this.myCommitClient != null) {
                this.myCommitClient.setOptions(options);
            }
            if (this.myCopyClient != null) {
                this.myCopyClient.setOptions(options);
            }
            if (this.myDiffClient != null) {
                this.myDiffClient.setOptions(options);
            }
            if (this.myLogClient != null) {
                this.myLogClient.setOptions(options);
            }
            if (this.myMoveClient != null) {
                this.myMoveClient.setOptions(options);
            }
            if (this.myStatusClient != null) {
                this.myStatusClient.setOptions(options);
            }
            if (this.myUpdateClient != null) {
                this.myUpdateClient.setOptions(options);
            }
            if (this.myWCClient != null) {
                this.myWCClient.setOptions(options);
            }
            if (this.myAdminClient != null) {
                this.myAdminClient.setOptions(options);
            }
            if (this.myLookClient != null) {
                this.myLookClient.setOptions(options);
            }
        }
    }

    public SVNCommitClient getCommitClient() {
        if (this.myCommitClient == null) {
            this.myCommitClient = this.myOperationFactory != null ? new SVNCommitClient(this.myOperationFactory) : new SVNCommitClient(this, this.myOptions);
            this.myCommitClient.setEventHandler(this.myEventHandler);
            this.myCommitClient.setDebugLog(this.getDebugLog());
            this.myCommitClient.setIgnoreExternals(this.myIsIgnoreExternals);
        }
        return this.myCommitClient;
    }

    public SVNAdminClient getAdminClient() {
        if (this.myAdminClient == null) {
            this.myAdminClient = this.myOperationFactory != null ? new SVNAdminClient(this.myOperationFactory) : new SVNAdminClient(this, this.myOptions);
            this.initClientDefaults(this.myAdminClient);
        }
        return this.myAdminClient;
    }

    public SVNLookClient getLookClient() {
        if (this.myLookClient == null) {
            this.myLookClient = this.myOperationFactory != null ? new SVNLookClient(this.myOperationFactory) : new SVNLookClient(this, this.myOptions);
            this.initClientDefaults(this.myLookClient);
        }
        return this.myLookClient;
    }

    public SVNCopyClient getCopyClient() {
        if (this.myCopyClient == null) {
            this.myCopyClient = this.myOperationFactory != null ? new SVNCopyClient(this.myOperationFactory) : new SVNCopyClient(this, this.myOptions);
            this.initClientDefaults(this.myCopyClient);
        }
        return this.myCopyClient;
    }

    public SVNDiffClient getDiffClient() {
        if (this.myDiffClient == null) {
            this.myDiffClient = this.myOperationFactory != null ? new SVNDiffClient(this.myOperationFactory) : new SVNDiffClient(this, this.myOptions);
            this.initClientDefaults(this.myDiffClient);
        }
        return this.myDiffClient;
    }

    public SVNLogClient getLogClient() {
        if (this.myLogClient == null) {
            this.myLogClient = this.myOperationFactory != null ? new SVNLogClient(this.myOperationFactory) : new SVNLogClient(this, this.myOptions);
            this.initClientDefaults(this.myLogClient);
        }
        return this.myLogClient;
    }

    public SVNMoveClient getMoveClient() {
        if (this.myMoveClient == null) {
            this.myMoveClient = this.myOperationFactory != null ? new SVNMoveClient(this.myOperationFactory) : new SVNMoveClient(this, this.myOptions);
            this.initClientDefaults(this.myMoveClient);
        }
        return this.myMoveClient;
    }

    public SVNStatusClient getStatusClient() {
        if (this.myStatusClient == null) {
            this.myStatusClient = this.myOperationFactory != null ? new SVNStatusClient(this.myOperationFactory) : new SVNStatusClient(this, this.myOptions);
            this.initClientDefaults(this.myStatusClient);
        }
        return this.myStatusClient;
    }

    public SVNUpdateClient getUpdateClient() {
        if (this.myUpdateClient == null) {
            this.myUpdateClient = this.myOperationFactory != null ? new SVNUpdateClient(this.myOperationFactory) : new SVNUpdateClient(this, this.myOptions);
            this.initClientDefaults(this.myUpdateClient);
        }
        return this.myUpdateClient;
    }

    public SVNWCClient getWCClient() {
        if (this.myWCClient == null) {
            this.myWCClient = this.myOperationFactory != null ? new SVNWCClient(this.myOperationFactory) : new SVNWCClient(this, this.myOptions);
            this.initClientDefaults(this.myWCClient);
        }
        return this.myWCClient;
    }

    public SVNChangelistClient getChangelistClient() {
        if (this.myChangelistClient == null) {
            this.myChangelistClient = this.myOperationFactory != null ? new SVNChangelistClient(this.myOperationFactory) : new SVNChangelistClient(this, this.myOptions);
            this.initClientDefaults(this.myChangelistClient);
        }
        return this.myChangelistClient;
    }

    protected void initClientDefaults(SVNBasicClient client) {
        client.setEventHandler(this.myEventHandler);
        client.setDebugLog(this.getDebugLog());
        client.setIgnoreExternals(this.myIsIgnoreExternals);
    }

    protected void initClientDefaults(SVNAdminBasicClient client) {
        client.setEventHandler(this.myEventHandler);
        client.setDebugLog(this.getDebugLog());
    }

    public ISVNDebugLog getDebugLog() {
        if (this.myDebugLog == null) {
            return SVNDebugLog.getDefaultLog();
        }
        return this.myDebugLog;
    }

    @Override
    public void setDebugLog(ISVNDebugLog log) {
        this.myDebugLog = log;
        if (this.myCommitClient != null) {
            this.myCommitClient.setDebugLog(log);
        }
        if (this.myCopyClient != null) {
            this.myCopyClient.setDebugLog(log);
        }
        if (this.myDiffClient != null) {
            this.myDiffClient.setDebugLog(log);
        }
        if (this.myLogClient != null) {
            this.myLogClient.setDebugLog(log);
        }
        if (this.myMoveClient != null) {
            this.myMoveClient.setDebugLog(log);
        }
        if (this.myStatusClient != null) {
            this.myStatusClient.setDebugLog(log);
        }
        if (this.myUpdateClient != null) {
            this.myUpdateClient.setDebugLog(log);
        }
        if (this.myWCClient != null) {
            this.myWCClient.setDebugLog(log);
        }
        if (this.myChangelistClient != null) {
            this.myChangelistClient.setDebugLog(log);
        }
        if (this.myAdminClient != null) {
            this.myAdminClient.setDebugLog(log);
        }
        if (this.myLookClient != null) {
            this.myLookClient.setDebugLog(log);
        }
        if (this.myRepositoryPool != null) {
            this.myRepositoryPool.setDebugLog(log);
        }
    }

    @Override
    public void setAuthenticationManager(ISVNAuthenticationManager authManager) {
        if (this.myOperationFactory != null) {
            this.myOperationFactory.setAuthenticationManager(authManager);
        } else if (this.myRepositoryPool != null) {
            this.myRepositoryPool.setAuthenticationManager(authManager);
        }
    }

    @Override
    public void setCanceller(ISVNCanceller canceller) {
        if (this.myOperationFactory != null) {
            this.myOperationFactory.setCanceller(canceller);
        } else if (this.myRepositoryPool != null) {
            this.myRepositoryPool.setCanceller(canceller);
        }
    }

    public ISVNRepositoryPool getRepositoryPool() {
        if (this.myOperationFactory != null) {
            return this.myOperationFactory.getRepositoryPool();
        }
        return this.myRepositoryPool;
    }

    public SvnOperationFactory getOperationFactory() {
        return this.myOperationFactory;
    }
}

