/*
 * Decompiled with CFR 0.152.
 */
package org.tmatesoft.svn.core.internal.util;

import java.io.Closeable;
import java.io.File;
import java.io.IOException;
import java.io.RandomAccessFile;
import org.tmatesoft.svn.core.SVNErrorCode;
import org.tmatesoft.svn.core.SVNErrorMessage;
import org.tmatesoft.svn.core.SVNException;
import org.tmatesoft.svn.core.internal.util.SVNSpillBufferInputStream;
import org.tmatesoft.svn.core.internal.wc.SVNErrorManager;
import org.tmatesoft.svn.core.internal.wc.SVNFileUtil;
import org.tmatesoft.svn.util.SVNLogType;

public class SVNSpillBuffer
implements Closeable {
    private final int blockSize;
    private final long maxSize;
    private final boolean deleteOnClose;
    private final boolean spillAllContents;
    private final File dirPath;
    private long memorySize;
    private long spillSize;
    private File fileName;
    private RandomAccessFile spill;
    private MemoryBlock head;
    private MemoryBlock tail;
    private MemoryBlock outForReading;
    private MemoryBlock available;
    private long spillStart;

    public SVNSpillBuffer(int blockSize, long maxSize) {
        this(blockSize, maxSize, true, false, null);
    }

    public SVNSpillBuffer(int blockSize, long maxSize, boolean deleteOnClose, boolean spillAllContents, File dirPath) {
        this.blockSize = blockSize;
        this.maxSize = maxSize;
        this.deleteOnClose = deleteOnClose;
        this.spillAllContents = spillAllContents;
        this.dirPath = dirPath;
    }

    public long getSize() {
        return this.memorySize + this.spillSize;
    }

    public long getMemorySize() {
        return this.memorySize;
    }

    public File getFileName() {
        return this.fileName;
    }

    public RandomAccessFile getSpill() {
        return this.spill;
    }

    public int getBlockSize() {
        return this.blockSize;
    }

    public SVNSpillBufferInputStream createInputStream() {
        return new SVNSpillBufferInputStream(this);
    }

    public void write(byte[] data, int offset, int length) throws SVNException {
        try {
            MemoryBlock block = null;
            if (this.spill == null && this.memorySize + (long)length > this.maxSize) {
                File dirPath = this.dirPath;
                if (dirPath == null) {
                    dirPath = SVNFileUtil.createFilePath(System.getProperty("java.io.tmpdir"));
                }
                this.fileName = SVNFileUtil.createUniqueFile(dirPath, "svn", ".tmp", false);
                this.spill = SVNFileUtil.openRAFileForWriting(this.fileName, false);
                assert (this.spill != null);
                if (this.spillAllContents) {
                    block = this.head;
                    while (block != null) {
                        this.spill.write(block.data, 0, block.length);
                        block = block.next;
                    }
                    this.spillStart = this.memorySize;
                }
            }
            if (this.spill != null) {
                this.spill.seek(this.spill.length());
                this.spill.write(data, offset, length);
                this.spillSize += (long)length;
                return;
            }
            while (length > 0) {
                if (this.tail == null || this.tail.length == this.blockSize) {
                    block = this.getBuffer();
                    block.length = 0;
                    block.next = null;
                } else {
                    block = this.tail;
                }
                int amt = this.blockSize - block.length;
                if (amt > length) {
                    amt = length;
                }
                System.arraycopy(data, offset, block.data, block.length, amt);
                block.length += amt;
                offset += amt;
                length -= amt;
                this.memorySize += (long)amt;
                if (this.tail == null) {
                    this.head = block;
                    this.tail = block;
                    continue;
                }
                if (block == this.tail) continue;
                this.tail.next = block;
                this.tail = block;
            }
        }
        catch (IOException e) {
            SVNErrorMessage errorMessage = SVNErrorMessage.create(SVNErrorCode.IO_ERROR, e);
            SVNErrorManager.error(errorMessage, SVNLogType.FSFS);
        }
    }

    @Override
    public void close() {
        SVNFileUtil.closeFile(this.spill);
        this.spill = null;
        if (this.deleteOnClose) {
            try {
                if (this.fileName != null) {
                    SVNFileUtil.deleteFile(this.fileName);
                    this.fileName = null;
                }
            }
            catch (SVNException sVNException) {
                // empty catch block
            }
        }
    }

    public MemoryBlock read() throws IOException {
        this.maybeSeek();
        MemoryBlock block = this.readData();
        if (block == null) {
            return null;
        }
        if (this.outForReading != null) {
            this.returnBuffer(this.outForReading);
        }
        this.outForReading = block;
        return block;
    }

    private boolean maybeSeek() throws IOException {
        if (this.head == null && this.spill != null) {
            this.spill.seek(this.spillStart);
            return true;
        }
        return false;
    }

    private MemoryBlock readData() throws IOException {
        if (this.head != null) {
            MemoryBlock block = this.head;
            if (this.tail == block) {
                this.tail = null;
                this.head = null;
            } else {
                this.head = block.next;
            }
            this.memorySize -= (long)block.length;
            return block;
        }
        if (this.spill == null) {
            MemoryBlock block = null;
            return block;
        }
        MemoryBlock block = this.getBuffer();
        block.length = this.spillSize < (long)this.blockSize ? (int)this.spillSize : this.blockSize;
        block.next = null;
        try {
            this.spill.read(block.data, 0, block.length);
        }
        catch (IOException e) {
            this.returnBuffer(block);
            throw e;
        }
        this.spillStart += (long)block.length;
        if ((this.spillSize -= (long)block.length) == 0L) {
            this.close();
            this.spillStart = 0L;
        }
        return block;
    }

    private MemoryBlock getBuffer() {
        MemoryBlock block = this.outForReading;
        if (block != null) {
            this.outForReading = null;
            return block;
        }
        if (this.available == null) {
            block = new MemoryBlock(new byte[this.blockSize], this.blockSize);
            return block;
        }
        block = this.available;
        this.available = block.next;
        return block;
    }

    private void returnBuffer(MemoryBlock block) {
        block.next = this.available;
        this.available = block;
    }

    static class MemoryBlock {
        protected final byte[] data;
        protected int length;
        protected MemoryBlock next;

        public MemoryBlock(byte[] data, int length) {
            this.data = data;
            this.length = length;
        }
    }
}

