/*
 * Decompiled with CFR 0.152.
 */
package org.tmatesoft.svn.core.internal.io.fs.index;

import java.io.Closeable;
import java.io.EOFException;
import java.io.File;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.util.logging.Level;
import org.tmatesoft.svn.core.SVNErrorCode;
import org.tmatesoft.svn.core.SVNErrorMessage;
import org.tmatesoft.svn.core.SVNException;
import org.tmatesoft.svn.core.internal.io.fs.FSFS;
import org.tmatesoft.svn.core.internal.io.fs.FSRepositoryUtil;
import org.tmatesoft.svn.core.internal.io.fs.index.FSL2PEntry;
import org.tmatesoft.svn.core.internal.wc.SVNErrorManager;
import org.tmatesoft.svn.core.internal.wc.SVNFileUtil;
import org.tmatesoft.svn.util.SVNDebugLog;
import org.tmatesoft.svn.util.SVNLogType;

public class FSL2PProtoIndex
implements Closeable {
    private static final long MAX_OFFSET = Integer.MAX_VALUE;
    private static final String FILENAME = "index.l2p";
    private final RandomAccessFile file;

    public static FSL2PProtoIndex open(FSFS fsfs, String txnId, boolean append) throws SVNException {
        try {
            RandomAccessFile randomAccessFile = new RandomAccessFile(FSL2PProtoIndex.getIndexPath(fsfs, txnId), "rw");
            if (append) {
                randomAccessFile.seek(randomAccessFile.length());
            }
            return new FSL2PProtoIndex(randomAccessFile);
        }
        catch (IOException e) {
            SVNErrorMessage errorMessage = SVNErrorMessage.create(SVNErrorCode.IO_ERROR, e);
            SVNErrorManager.error(errorMessage, SVNLogType.FSFS);
            return null;
        }
    }

    public static File getIndexPath(FSFS fsfs, String txnId) {
        File transactionDir = fsfs.getTransactionDir(txnId);
        return SVNFileUtil.createFilePath(transactionDir, FILENAME);
    }

    public FSL2PProtoIndex(RandomAccessFile file) {
        this.file = file;
    }

    @Override
    public void close() {
        try {
            this.file.close();
        }
        catch (IOException e) {
            SVNDebugLog.getDefaultLog().log(SVNLogType.FSFS, e, Level.INFO);
        }
    }

    public long getOffsetByItemIndex(long itemIndex) throws SVNException {
        try {
            if (this.file.length() % 16L != 0L) {
                SVNErrorMessage errorMessage = SVNErrorMessage.create(SVNErrorCode.FS_INDEX_CORRUPTION);
                SVNErrorManager.error(errorMessage, SVNLogType.FSFS);
            }
        }
        catch (IOException e) {
            SVNErrorMessage errorMessage = SVNErrorMessage.create(SVNErrorCode.IO_ERROR, e);
            SVNErrorManager.error(errorMessage, SVNLogType.FSFS);
        }
        long[] entryOffset = new long[1];
        long[] entryItemIndex = new long[1];
        this.readEntry(entryOffset, entryItemIndex);
        if (entryItemIndex[0] == itemIndex) {
            return entryOffset[0] - 1L;
        }
        return -1L;
    }

    public FSL2PEntry readEntry() throws SVNException {
        long[] entryOffset = new long[1];
        long[] entryItemIndex = new long[1];
        this.readEntry(entryOffset, entryItemIndex);
        if (entryOffset[0] < 0L || entryItemIndex[0] < 0L) {
            return null;
        }
        return new FSL2PEntry(entryOffset[0], entryItemIndex[0]);
    }

    private void readEntry(long[] entryOffset, long[] entryItemIndex) throws SVNException {
        try {
            entryOffset[0] = FSRepositoryUtil.readLongLittleEndian(this.file);
            entryItemIndex[0] = FSRepositoryUtil.readLongLittleEndian(this.file);
        }
        catch (EOFException e) {
            entryOffset[0] = -1L;
            entryItemIndex[0] = -1L;
        }
        catch (IOException e) {
            SVNErrorMessage errorMessage = SVNErrorMessage.create(SVNErrorCode.IO_ERROR, e);
            SVNErrorManager.error(errorMessage, SVNLogType.FSFS);
        }
    }

    public void addEntry(long offset, long itemIndex) throws SVNException {
        try {
            assert (offset >= -1L);
            FSRepositoryUtil.writeLongLittleEndian(this.file, offset + 1L);
            FSRepositoryUtil.writeLongLittleEndian(this.file, itemIndex);
        }
        catch (IOException e) {
            SVNErrorMessage errorMessage = SVNErrorMessage.create(SVNErrorCode.IO_ERROR, e);
            SVNErrorManager.error(errorMessage, SVNLogType.FSFS);
        }
    }
}

