/*
 * Decompiled with CFR 0.152.
 */
package org.tmatesoft.svn.core.internal.wc2.old;

import java.io.File;
import org.tmatesoft.svn.core.SVNErrorCode;
import org.tmatesoft.svn.core.SVNErrorMessage;
import org.tmatesoft.svn.core.SVNException;
import org.tmatesoft.svn.core.SVNURL;
import org.tmatesoft.svn.core.internal.wc.SVNErrorManager;
import org.tmatesoft.svn.core.internal.wc.admin.SVNEntry;
import org.tmatesoft.svn.core.internal.wc.admin.SVNWCAccess;
import org.tmatesoft.svn.core.internal.wc17.SVNWCContext;
import org.tmatesoft.svn.core.internal.wc17.db.Structure;
import org.tmatesoft.svn.core.internal.wc2.SvnRepositoryAccess;
import org.tmatesoft.svn.core.io.SVNRepository;
import org.tmatesoft.svn.core.wc.SVNRevision;
import org.tmatesoft.svn.core.wc2.ISvnOperationOptionsProvider;
import org.tmatesoft.svn.core.wc2.SvnCopySource;
import org.tmatesoft.svn.core.wc2.SvnTarget;
import org.tmatesoft.svn.util.SVNLogType;

public class SvnOldRepositoryAccess
extends SvnRepositoryAccess {
    public SvnOldRepositoryAccess(ISvnOperationOptionsProvider operationOptionsProvider) throws SVNException {
        super(operationOptionsProvider, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public SvnCopySource createRemoteCopySource(SVNWCContext context, SvnCopySource localCopySource) throws SVNException {
        File path = localCopySource.getSource().getFile();
        try (SVNWCAccess wcAccess = SVNWCAccess.newInstance(null);){
            SVNURL url;
            wcAccess.probeOpen(path, false, 0);
            SVNEntry entry = wcAccess.getEntry(path, false);
            SVNURL sVNURL = url = entry.isCopied() ? entry.getCopyFromSVNURL() : entry.getSVNURL();
            if (url == null) {
                SVNErrorMessage err = SVNErrorMessage.create(SVNErrorCode.ENTRY_MISSING_URL, "''{0}'' does not have a URL associated with it", (Object)path);
                SVNErrorManager.error(err, SVNLogType.WC);
            }
            SVNRevision pegRevision = localCopySource.getSource().getResolvedPegRevision();
            SVNRevision revision = localCopySource.getRevision();
            if (pegRevision == SVNRevision.UNDEFINED || pegRevision == SVNRevision.WORKING || pegRevision == SVNRevision.BASE) {
                SVNRevision sVNRevision = pegRevision = entry.isCopied() ? SVNRevision.create(entry.getCopyFromRevision()) : SVNRevision.create(entry.getRevision());
            }
            if (revision == SVNRevision.BASE) {
                revision = entry.isCopied() ? SVNRevision.create(entry.getCopyFromRevision()) : SVNRevision.create(entry.getRevision());
            }
            SvnCopySource svnCopySource = SvnCopySource.create(SvnTarget.fromURL(url, pegRevision), revision);
            return svnCopySource;
        }
    }

    @Override
    public Structure<SvnRepositoryAccess.RepositoryInfo> createRepositoryFor(SvnTarget target, SVNRevision revision, SVNRevision pegRevision, File baseDirectory) throws SVNException {
        SVNURL url = this.getURL(target);
        if (url == null) {
            SVNErrorMessage err = SVNErrorMessage.create(SVNErrorCode.ENTRY_MISSING_URL, "''{0}'' has no URL", (Object)target.getFile());
            SVNErrorManager.error(err, SVNLogType.WC);
        }
        SVNRevision[] resolvedRevisions = this.resolveRevisions(pegRevision, revision, target.isURL(), true);
        SVNRevision pegRev = resolvedRevisions[0];
        SVNRevision startRev = resolvedRevisions[1];
        SVNRepository repository = this.createRepository(url, null, true);
        if (target.isURL() && !url.equals(repository.getLocation())) {
            url = repository.getLocation();
        }
        Structure<SvnRepositoryAccess.LocationsInfo> locationsInfo = this.getLocations(repository, target, pegRev, startRev, SVNRevision.UNDEFINED);
        long rev = locationsInfo.lng(SvnRepositoryAccess.LocationsInfo.startRevision);
        url = (SVNURL)locationsInfo.get(SvnRepositoryAccess.LocationsInfo.startUrl);
        locationsInfo.release();
        repository.setLocation(url, false);
        if (rev < 0L) {
            Structure<SvnRepositoryAccess.RevisionsPair> revs = this.getRevisionNumber(repository, target, SVNRevision.HEAD, null);
            rev = revs.lng(SvnRepositoryAccess.RevisionsPair.revNumber);
            revs.release();
        }
        Object result = Structure.obtain(SvnRepositoryAccess.RepositoryInfo.class);
        ((Structure)result).set((SvnRepositoryAccess.RepositoryInfo)SvnRepositoryAccess.RepositoryInfo.revision, rev);
        ((Structure)result).set((SvnRepositoryAccess.RepositoryInfo)SvnRepositoryAccess.RepositoryInfo.repository, repository);
        ((Structure)result).set((SvnRepositoryAccess.RepositoryInfo)SvnRepositoryAccess.RepositoryInfo.url, url);
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Structure<SvnRepositoryAccess.RevisionsPair> getRevisionNumber(SVNRepository repository, SvnTarget path, SVNRevision revision, Structure<SvnRepositoryAccess.RevisionsPair> youngestRevision) throws SVNException {
        SVNErrorMessage err;
        Structure<SvnRepositoryAccess.RevisionsPair> result;
        Structure<SvnRepositoryAccess.RevisionsPair> structure = result = youngestRevision == null ? Structure.obtain(SvnRepositoryAccess.RevisionsPair.class) : youngestRevision;
        if (repository == null && (revision == SVNRevision.HEAD || revision.getDate() != null)) {
            err = SVNErrorMessage.create(SVNErrorCode.CLIENT_RA_ACCESS_REQUIRED);
            SVNErrorManager.error(err, SVNLogType.WC);
        }
        if (revision.getNumber() >= 0L) {
            result.set(SvnRepositoryAccess.RevisionsPair.revNumber, revision.getNumber());
        } else if (revision.getDate() != null) {
            result.set(SvnRepositoryAccess.RevisionsPair.revNumber, repository.getDatedRevision(revision.getDate()));
        } else if (revision == SVNRevision.HEAD) {
            if (youngestRevision != null && youngestRevision.hasValue(SvnRepositoryAccess.RevisionsPair.youngestRevision) && youngestRevision.lng(SvnRepositoryAccess.RevisionsPair.youngestRevision) >= 0L) {
                result.set(SvnRepositoryAccess.RevisionsPair.revNumber, youngestRevision.lng(SvnRepositoryAccess.RevisionsPair.youngestRevision));
            } else {
                long latestRevision = repository.getLatestRevision();
                result.set(SvnRepositoryAccess.RevisionsPair.revNumber, latestRevision);
                result.set(SvnRepositoryAccess.RevisionsPair.youngestRevision, latestRevision);
            }
        } else if (revision == SVNRevision.COMMITTED || revision == SVNRevision.WORKING || revision == SVNRevision.BASE || revision == SVNRevision.PREVIOUS) {
            if (path == null || path.isURL()) {
                err = SVNErrorMessage.create(SVNErrorCode.CLIENT_VERSIONED_PATH_REQUIRED);
                SVNErrorManager.error(err, SVNLogType.WC);
            }
            SVNWCAccess wcAccess = this.createWCAccess();
            wcAccess.probeOpen(path.getFile(), false, 0);
            SVNEntry entry = null;
            try {
                entry = wcAccess.getVersionedEntry(path.getFile(), false);
            }
            finally {
                wcAccess.close();
            }
            if (revision == SVNRevision.WORKING || revision == SVNRevision.BASE) {
                result.set(SvnRepositoryAccess.RevisionsPair.revNumber, entry.getRevision());
            } else if (entry.getCommittedRevision() < 0L) {
                SVNErrorMessage err2 = SVNErrorMessage.create(SVNErrorCode.CLIENT_BAD_REVISION, "Path ''{0}'' has no committed revision", (Object)path);
                SVNErrorManager.error(err2, SVNLogType.WC);
            } else {
                result.set(SvnRepositoryAccess.RevisionsPair.revNumber, revision == SVNRevision.PREVIOUS ? entry.getCommittedRevision() - 1L : entry.getCommittedRevision());
            }
        } else {
            err = SVNErrorMessage.create(SVNErrorCode.CLIENT_BAD_REVISION, "Unrecognized revision type requested for ''{0}''", path != null ? path : repository.getLocation());
            SVNErrorManager.error(err, SVNLogType.WC);
        }
        return result;
    }

    protected SVNWCAccess createWCAccess() {
        SVNWCAccess access = SVNWCAccess.newInstance(this.getOperationOptionsProvider().getEventHandler());
        access.setOptions(this.getOperationOptionsProvider().getOptions());
        return access;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Structure<SvnRepositoryAccess.UrlInfo> getURLFromPath(SvnTarget path, SVNRevision revision, SVNRepository repository) throws SVNException {
        Object urlInfo = Structure.obtain(SvnRepositoryAccess.UrlInfo.class);
        SVNURL url = null;
        try (SVNWCAccess wcAccess = SVNWCAccess.newInstance(null);){
            wcAccess.openAnchor(path.getFile(), false, 0);
            SVNEntry entry = wcAccess.getVersionedEntry(path.getFile(), false);
            if (entry.getCopyFromURL() != null && revision == SVNRevision.WORKING) {
                url = entry.getCopyFromSVNURL();
                ((Structure)urlInfo).set((SvnRepositoryAccess.UrlInfo)SvnRepositoryAccess.UrlInfo.pegRevision, entry.getCopyFromRevision());
                if (entry.getURL() == null || !entry.getURL().equals(entry.getCopyFromURL())) {
                    ((Structure)urlInfo).set((SvnRepositoryAccess.UrlInfo)SvnRepositoryAccess.UrlInfo.dropRepsitory, true);
                    repository = null;
                }
            } else if (entry.getURL() != null) {
                url = entry.getSVNURL();
            } else {
                SVNErrorMessage err = SVNErrorMessage.create(SVNErrorCode.ENTRY_MISSING_URL, "''{0}'' has no URL", (Object)path);
                SVNErrorManager.error(err, SVNLogType.WC);
            }
        }
        ((Structure)urlInfo).set((SvnRepositoryAccess.UrlInfo)SvnRepositoryAccess.UrlInfo.url, url);
        return urlInfo;
    }

    protected SVNURL getURL(SvnTarget target) throws SVNException {
        if (target.isURL()) {
            return target.getURL();
        }
        return this.deriveLocation(target.getFile(), null, null, SVNRevision.UNDEFINED, null, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected SVNURL deriveLocation(File path, SVNURL url, long[] pegRevisionNumber, SVNRevision pegRevision, SVNRepository repos, SVNWCAccess access) throws SVNException {
        if (path != null) {
            SVNEntry entry = null;
            if (access != null) {
                entry = access.getVersionedEntry(path, false);
            } else {
                try (SVNWCAccess wcAccess = this.createWCAccess();){
                    wcAccess.probeOpen(path, false, 0);
                    entry = wcAccess.getVersionedEntry(path, false);
                }
            }
            url = this.getEntryLocation(path, entry, pegRevisionNumber, pegRevision);
        }
        if (pegRevisionNumber != null && pegRevisionNumber.length > 0 && !SVNRevision.isValidRevisionNumber(pegRevisionNumber[0])) {
            boolean closeRepository = false;
            try {
                if (repos == null) {
                    repos = this.createRepository(url, null, false);
                    closeRepository = true;
                } else {
                    repos.setLocation(url, false);
                }
                Structure<SvnRepositoryAccess.RevisionsPair> revPair = this.getRevisionNumber(repos, path != null ? SvnTarget.fromFile(path) : null, pegRevision, null);
                pegRevisionNumber[0] = revPair.lng(SvnRepositoryAccess.RevisionsPair.revNumber);
            }
            finally {
                if (closeRepository) {
                    repos.closeSession();
                }
            }
        }
        return url;
    }

    protected SVNURL getEntryLocation(File path, SVNEntry entry, long[] revNum, SVNRevision pegRevision) throws SVNException {
        SVNURL url = null;
        if (entry.getCopyFromURL() != null && pegRevision == SVNRevision.WORKING) {
            url = entry.getCopyFromSVNURL();
            if (revNum != null && revNum.length > 0) {
                revNum[0] = entry.getCopyFromRevision();
            }
        } else if (entry.getURL() != null) {
            url = entry.getSVNURL();
            if (revNum != null && revNum.length > 0) {
                revNum[0] = entry.getRevision();
            }
        } else {
            SVNErrorMessage err = SVNErrorMessage.create(SVNErrorCode.ENTRY_MISSING_URL, "Entry for ''{0}'' has no URL", (Object)path);
            SVNErrorManager.error(err, SVNLogType.WC);
        }
        return url;
    }
}

