package com.xebialabs.xlrelease.plugin.svn;

import org.tmatesoft.svn.core.SVNDirEntry;
import org.tmatesoft.svn.core.SVNException;
import org.tmatesoft.svn.core.SVNURL;
import org.tmatesoft.svn.core.auth.ISVNAuthenticationManager;
import org.tmatesoft.svn.core.io.SVNRepository;

public class SvnClient {
    private String svnRoot;
    private String userName;
    private String password;
    private SvnKitFacade svnKitFacade;

    public SvnClient(String svnRoot, String userName, String password) {
        this(svnRoot, userName, password, new SvnKitFacade());
    }

    SvnClient(String svnRoot, String userName, String password, SvnKitFacade svnKitFacade) {
        this.svnRoot = svnRoot;
        this.userName = userName;
        this.password = password;
        this.svnKitFacade = svnKitFacade;
    }

    public long getLatestRevision() throws SVNException {
        return getLatestRevision(null);
    }

    public long getLatestRevision(String lastRevisionChecked) throws SVNException {
        svnKitFacade.setup();
        SVNRepository repository = svnKitFacade.create(svnRoot);
        ISVNAuthenticationManager authenticationManager = svnKitFacade.createDefaultAuthenticationManager(userName, password);
        repository.setAuthenticationManager(authenticationManager);
        final long latestRevision = repository.getLatestRevision();
        if (lastRevisionChecked == null) {
            return latestRevision;
        }
        long lastRevisionCheckedLong = Long.parseLong(lastRevisionChecked);
        final SVNDirEntry folderInfo = repository.info(getRelativePath(repository), repository.getLatestRevision());
        // check if the "branch" was modified on the latest revision
        if (folderInfo.getRevision() >= lastRevisionCheckedLong && lastRevisionCheckedLong != latestRevision) {
            return latestRevision;
        }
        return lastRevisionCheckedLong;
    }

    private String getRelativePath(SVNRepository repository) throws SVNException {
        String  repoPath = SVNURL.parseURIEncoded(svnRoot).getPath()
                                 .substring(repository.getRepositoryRoot(true).getPath().length());
        if(!repoPath.startsWith("/")) {
            repoPath = "/" + repoPath;
        }
        return repoPath;
    }
}
