/*
 * Decompiled with CFR 0.152.
 */
package org.tmatesoft.svn.core.internal.wc17;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import org.tmatesoft.svn.core.SVNCommitInfo;
import org.tmatesoft.svn.core.SVNErrorCode;
import org.tmatesoft.svn.core.SVNErrorMessage;
import org.tmatesoft.svn.core.SVNException;
import org.tmatesoft.svn.core.SVNNodeKind;
import org.tmatesoft.svn.core.SVNProperties;
import org.tmatesoft.svn.core.SVNPropertyValue;
import org.tmatesoft.svn.core.SVNURL;
import org.tmatesoft.svn.core.internal.util.SVNEncodingUtil;
import org.tmatesoft.svn.core.internal.util.SVNPathUtil;
import org.tmatesoft.svn.core.internal.wc.SVNErrorManager;
import org.tmatesoft.svn.core.internal.wc.SVNFileUtil;
import org.tmatesoft.svn.core.internal.wc.admin.SVNChecksumInputStream;
import org.tmatesoft.svn.core.internal.wc17.ISVNEditor2;
import org.tmatesoft.svn.core.internal.wc17.ISVNEditorProxyCallbacks;
import org.tmatesoft.svn.core.io.ISVNEditor;
import org.tmatesoft.svn.core.io.diff.SVNDeltaProcessor;
import org.tmatesoft.svn.core.io.diff.SVNDiffWindow;
import org.tmatesoft.svn.core.wc.SVNRevision;
import org.tmatesoft.svn.core.wc2.SvnChecksum;
import org.tmatesoft.svn.util.SVNDebugLog;
import org.tmatesoft.svn.util.SVNLogType;

public class SVNEditorProxy
implements ISVNEditor {
    private final ISVNEditor2 editor2;
    private final ISVNEditorProxyCallbacks proxyCallbacks;
    private DirectoryBaton currentDirectoryBaton;
    private FileBaton currentFileBaton;
    private InputStream source;
    private OutputStream target;
    private SVNDeltaProcessor svnDeltaProcessor;
    private boolean closed;
    private List<String> pathOrder;
    private Map<String, ChangeNode> changes;
    private SVNURL repositoryRoot;
    private String baseRelPath;
    private File tempDirectory;

    public SVNEditorProxy(ISVNEditor2 editor2, ISVNEditorProxyCallbacks proxyCallbacks) {
        this.editor2 = editor2;
        this.proxyCallbacks = proxyCallbacks;
        this.svnDeltaProcessor = new SVNDeltaProcessor();
        this.tempDirectory = new File(System.getProperty("java.io.tmpdir"));
        this.changes = new HashMap<String, ChangeNode>();
        this.pathOrder = new ArrayList<String>();
    }

    public void setRepositoryRoot(SVNURL repositoryRoot) {
        this.repositoryRoot = repositoryRoot;
    }

    public void setBaseRelPath(String baseRelPath) {
        this.baseRelPath = baseRelPath;
    }

    public void setTempDirectory(File tempDirectory) {
        this.tempDirectory = tempDirectory;
    }

    @Override
    public void targetRevision(long revision) throws SVNException {
        this.proxyCallbacks.getExtraCallbacks().targetRevision(revision);
    }

    @Override
    public void openRoot(long revision) throws SVNException {
        DirectoryBaton directoryBaton = new DirectoryBaton();
        directoryBaton.path = "";
        this.proxyCallbacks.getExtraCallbacks().startEdit(revision);
        directoryBaton.parent = this.currentDirectoryBaton;
        this.currentDirectoryBaton = directoryBaton;
    }

    @Override
    public void deleteEntry(String path, long revision) throws SVNException {
        String relPath = this.mapToReposRelPath(path);
        ChangeNode change = this.locateChange(relPath);
        long baseRevision = SVNRevision.isValidRevisionNumber(revision) ? revision : this.currentDirectoryBaton.baseRevision;
        assert (change.action == RestructureAction.RESTRUCTURE_NONE);
        change.action = RestructureAction.RESTRUCTURE_DELETE;
        assert (!SVNRevision.isValidRevisionNumber(change.deleting) || change.deleting == baseRevision);
        change.deleting = baseRevision;
    }

    @Override
    public void addDir(String path, String copyFromPath, long copyFromRevision) throws SVNException {
        DirectoryBaton directoryBaton = new DirectoryBaton();
        String relPath = this.mapToReposRelPath(path);
        ChangeNode change = this.locateChange(relPath);
        change.action = RestructureAction.RESTRUCTURE_ADD;
        change.kind = SVNNodeKind.DIR;
        directoryBaton.path = relPath;
        directoryBaton.baseRevision = this.currentDirectoryBaton.baseRevision;
        if (copyFromPath == null) {
            if (this.currentDirectoryBaton.copyFromRelPath != null) {
                String name = SVNPathUtil.tail(relPath);
                directoryBaton.copyFromRelPath = SVNPathUtil.append(this.currentDirectoryBaton.copyFromRelPath, name);
                directoryBaton.copyFromRevision = this.currentDirectoryBaton.copyFromRevision;
            }
        } else {
            change.copyFromPath = this.mapToReposRelPath(copyFromPath);
            change.copyFromRevision = copyFromRevision;
            directoryBaton.copyFromRelPath = change.copyFromPath;
            directoryBaton.copyFromRevision = change.copyFromRevision;
        }
        directoryBaton.parent = this.currentDirectoryBaton;
        this.currentDirectoryBaton = directoryBaton;
    }

    @Override
    public void openDir(String path, long revision) throws SVNException {
        String relPath;
        DirectoryBaton directoryBaton = new DirectoryBaton();
        directoryBaton.path = relPath = this.mapToReposRelPath(path);
        directoryBaton.baseRevision = revision;
        if (this.currentDirectoryBaton.copyFromRelPath != null) {
            String name = SVNPathUtil.tail(relPath);
            directoryBaton.copyFromRelPath = SVNPathUtil.append(this.currentDirectoryBaton.copyFromRelPath, name);
            directoryBaton.copyFromRevision = this.currentDirectoryBaton.copyFromRevision;
        }
        directoryBaton.parent = this.currentDirectoryBaton;
        this.currentDirectoryBaton = directoryBaton;
    }

    @Override
    public void changeDirProperty(String name, SVNPropertyValue value) throws SVNException {
        this.applyPropEdit(this.currentDirectoryBaton.path, SVNNodeKind.DIR, this.currentDirectoryBaton.baseRevision, name, value);
    }

    @Override
    public void closeDir() throws SVNException {
        this.currentDirectoryBaton = this.currentDirectoryBaton.parent;
    }

    @Override
    public void absentDir(String path) throws SVNException {
        String relPath = this.mapToReposRelPath(path);
        ChangeNode change = this.locateChange(relPath);
        change.action = RestructureAction.RESTRUCTURE_ADD_ABSENT;
        change.kind = SVNNodeKind.DIR;
    }

    @Override
    public void addFile(String path, String copyFromPath, long copyFromRevision) throws SVNException {
        this.currentFileBaton = new FileBaton();
        String relPath = this.mapToReposRelPath(path);
        ChangeNode change = this.locateChange(relPath);
        change.action = RestructureAction.RESTRUCTURE_ADD;
        change.kind = SVNNodeKind.FILE;
        this.currentFileBaton.path = relPath;
        this.currentFileBaton.baseRevision = this.currentDirectoryBaton.baseRevision;
        if (copyFromPath == null) {
            this.currentFileBaton.deltaBase = null;
        } else {
            change.copyFromPath = this.mapToReposRelPath(copyFromPath);
            change.copyFromRevision = copyFromRevision;
            this.currentFileBaton.deltaBase = this.proxyCallbacks.fetchBase(copyFromPath, copyFromRevision);
        }
    }

    @Override
    public void openFile(String path, long revision) throws SVNException {
        String relPath;
        this.currentFileBaton = new FileBaton();
        this.currentFileBaton.path = relPath = this.mapToReposRelPath(path);
        this.currentFileBaton.baseRevision = revision;
        if (this.currentDirectoryBaton.copyFromRelPath != null) {
            String name = SVNPathUtil.tail(relPath);
            String copyFromRelPath = SVNPathUtil.append(this.currentDirectoryBaton.copyFromRelPath, name);
            this.currentFileBaton.deltaBase = this.proxyCallbacks.fetchBase(copyFromRelPath, this.currentDirectoryBaton.copyFromRevision);
        } else {
            this.currentFileBaton.deltaBase = this.proxyCallbacks.fetchBase(relPath, revision);
        }
    }

    @Override
    public void applyTextDelta(String path, String baseChecksum) throws SVNException {
        ChangeNode change = this.locateChange(this.currentFileBaton.path);
        assert (!change.contentsChanged);
        assert (change.contentsAbsPath == null);
        assert (!SVNRevision.isValidRevisionNumber(change.changing) || change.changing == this.currentFileBaton.baseRevision);
        change.changing = this.currentFileBaton.baseRevision;
        this.source = this.currentFileBaton.deltaBase == null ? SVNFileUtil.DUMMY_IN : this.openDeltaBase(this.currentFileBaton);
        change.contentsChanged = true;
        this.target = this.openDeltaTarget(this.currentFileBaton);
        change.contentsAbsPath = this.currentFileBaton.deltaTarget;
        this.svnDeltaProcessor.applyTextDelta(this.source, this.target, true);
    }

    @Override
    public OutputStream textDeltaChunk(String path, SVNDiffWindow diffWindow) throws SVNException {
        return this.svnDeltaProcessor.textDeltaChunk(diffWindow);
    }

    @Override
    public void textDeltaEnd(String path) throws SVNException {
        this.svnDeltaProcessor.textDeltaEnd();
    }

    @Override
    public void changeFileProperty(String path, String propertyName, SVNPropertyValue propertyValue) throws SVNException {
        if ("svn:entry:lock-token".equals(propertyName) && propertyValue == null) {
            String relPath = this.mapToReposRelPath(this.currentFileBaton.path);
            ChangeNode change = this.locateChange(relPath);
            change.unlock = true;
        }
        this.applyPropEdit(this.currentFileBaton.path, SVNNodeKind.FILE, this.currentFileBaton.baseRevision, propertyName, propertyValue);
    }

    @Override
    public void closeFile(String path, String textChecksum) throws SVNException {
        SVNFileUtil.closeFile(this.source);
        SVNFileUtil.closeFile(this.target);
        try {
            SVNFileUtil.deleteFile(this.currentFileBaton.deltaTarget);
        }
        catch (SVNException e) {
            SVNDebugLog.getDefaultLog().log(SVNLogType.CLIENT, e, Level.ALL);
        }
    }

    @Override
    public void absentFile(String path) throws SVNException {
        String relPath = this.mapToReposRelPath(path);
        ChangeNode change = this.locateChange(relPath);
        change.action = RestructureAction.RESTRUCTURE_ADD_ABSENT;
        change.kind = SVNNodeKind.FILE;
    }

    @Override
    public SVNCommitInfo closeEdit() throws SVNException {
        this.runEv2Actions();
        this.closed = true;
        this.editor2.complete();
        return null;
    }

    @Override
    public void abortEdit() throws SVNException {
        this.runEv2Actions();
        if (!this.closed) {
            this.editor2.abort();
        }
    }

    private void applyPropEdit(String relPath, SVNNodeKind kind, long baseRevision, String name, SVNPropertyValue value) {
        ChangeNode change = this.locateChange(relPath);
        assert (change.kind == SVNNodeKind.UNKNOWN || change.kind == kind);
        change.kind = kind;
        assert (!SVNRevision.isValidRevisionNumber(change.changing) || change.changing == baseRevision);
        change.changing = baseRevision;
        if (change.properties == null) {
            if (change.copyFromPath != null) {
                change.properties = this.proxyCallbacks.fetchProperties(change.copyFromPath, change.copyFromRevision);
            } else if (change.action == RestructureAction.RESTRUCTURE_ADD) {
                change.properties = new SVNProperties();
            } else {
                change.properties = this.proxyCallbacks.fetchProperties(relPath, baseRevision);
            }
        }
        if (change.properties == null) {
            change.properties = new SVNProperties();
        }
        if (value == null) {
            change.properties.put(name, (SVNPropertyValue)null);
        } else {
            change.properties.put(name, value);
        }
    }

    private void runEv2Actions() throws SVNException {
        for (String reposRelPath : this.pathOrder) {
            ChangeNode change = this.changes.get(reposRelPath);
            this.processAction(reposRelPath, change);
        }
    }

    private void processAction(String reposRelPath, ChangeNode change) throws SVNException {
        SVNProperties props = null;
        InputStream contents = null;
        SVNNodeKind kind = SVNNodeKind.UNKNOWN;
        SvnChecksum checksum = null;
        if (change.unlock) {
            this.proxyCallbacks.unlock(reposRelPath);
        }
        if (change.action == RestructureAction.RESTRUCTURE_DELETE) {
            this.editor2.delete(reposRelPath, change.deleting);
            return;
        }
        if (change.action == RestructureAction.RESTRUCTURE_ADD_ABSENT) {
            this.editor2.addAbsent(reposRelPath, change.kind, change.deleting);
        }
        if (change.contentsChanged) {
            kind = SVNNodeKind.FILE;
            if (change.contentsAbsPath != null) {
                checksum = this.fileChecksum(change.contentsAbsPath, SvnChecksum.Kind.sha1);
                contents = SVNFileUtil.openFileForReading(change.contentsAbsPath);
            } else {
                contents = SVNFileUtil.DUMMY_IN;
                checksum = new SvnChecksum(SvnChecksum.Kind.sha1, "da39a3ee5e6b4b0d3255bfef95601890afd80709");
            }
        }
        if (change.properties != null) {
            kind = change.kind;
            props = change.properties;
        }
        if (change.action == RestructureAction.RESTRUCTURE_ADD) {
            long replacesRevision = change.deleting;
            kind = change.kind;
            if (change.copyFromPath != null) {
                this.editor2.copy(change.copyFromPath, change.copyFromRevision, reposRelPath, replacesRevision);
            } else {
                if (props == null) {
                    props = new SVNProperties();
                }
                if (kind == SVNNodeKind.DIR) {
                    List<String> children = this.getChildren(reposRelPath);
                    this.editor2.addDir(reposRelPath, children, props, replacesRevision);
                } else {
                    if (change.contentsAbsPath == null) {
                        contents = SVNFileUtil.DUMMY_IN;
                        checksum = new SvnChecksum(SvnChecksum.Kind.sha1, "da39a3ee5e6b4b0d3255bfef95601890afd80709");
                    }
                    this.editor2.addFile(reposRelPath, checksum, contents, props, replacesRevision);
                }
            }
        }
        if (props != null || contents != null) {
            if (kind == SVNNodeKind.DIR) {
                this.editor2.alterDir(reposRelPath, change.changing, null, props);
            } else {
                this.editor2.alterFile(reposRelPath, change.changing, props, checksum, contents);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private SvnChecksum fileChecksum(File contentsAbsPath, SvnChecksum.Kind kind) throws SVNException {
        SVNChecksumInputStream checksumInputStream = new SVNChecksumInputStream(SVNFileUtil.openFileForReading(contentsAbsPath), kind.name());
        try {
            byte[] buffer = new byte[2048];
            while (true) {
                int bytesRead;
                if ((bytesRead = checksumInputStream.read(buffer)) < 0) {
                    SvnChecksum svnChecksum = new SvnChecksum(kind, checksumInputStream.getDigest());
                    return svnChecksum;
                }
                continue;
                break;
            }
        }
        catch (IOException e) {
            SVNErrorMessage errorMessage = SVNErrorMessage.create(SVNErrorCode.IO_ERROR, e);
            SVNErrorManager.error(errorMessage, SVNLogType.CLIENT);
            return null;
        }
        finally {
            SVNFileUtil.closeFile(checksumInputStream);
        }
    }

    private List<String> getChildren(String path) {
        ArrayList<String> children = new ArrayList<String>();
        for (Map.Entry<String, ChangeNode> entry : this.changes.entrySet()) {
            String reposRelPath = entry.getKey();
            String child = SVNPathUtil.getPathAsChild(path, reposRelPath);
            if (child == null || child.length() == 0 || child.indexOf(47) >= 0) continue;
            children.add(child);
        }
        return children;
    }

    private ChangeNode locateChange(String relPath) {
        ChangeNode change = this.changes.get(relPath);
        if (change != null) {
            return change;
        }
        this.pathOrder.add(relPath);
        change = new ChangeNode();
        change.changing = -1L;
        change.deleting = -1L;
        change.kind = SVNNodeKind.UNKNOWN;
        this.changes.put(relPath, change);
        return change;
    }

    private String mapToReposRelPath(String pathOrUrl) {
        if (SVNPathUtil.isURL(pathOrUrl)) {
            return SVNPathUtil.getPathAsChild(SVNEncodingUtil.uriDecode(pathOrUrl), this.repositoryRoot.toDecodedString());
        }
        return SVNPathUtil.append(this.baseRelPath, pathOrUrl.startsWith("/") ? pathOrUrl.substring("/".length()) : pathOrUrl);
    }

    private InputStream openDeltaBase(FileBaton fileBaton) throws SVNException {
        return SVNFileUtil.openFileForReading(fileBaton.deltaBase);
    }

    private OutputStream openDeltaTarget(FileBaton fileBaton) throws SVNException {
        fileBaton.deltaTarget = SVNFileUtil.createUniqueFile(this.tempDirectory, "editor", ".tmp", false);
        return SVNFileUtil.openFileForWriting(fileBaton.deltaTarget);
    }

    private static class FileBaton {
        public String path;
        public long baseRevision;
        public File deltaBase;
        public File deltaTarget;

        private FileBaton() {
        }
    }

    private static class DirectoryBaton {
        public long baseRevision;
        public String path;
        public DirectoryBaton parent;
        public String copyFromRelPath;
        public long copyFromRevision;

        private DirectoryBaton() {
        }
    }

    private static class ChangeNode {
        private RestructureAction action;
        private SVNNodeKind kind;
        private long changing;
        private long deleting;
        private SVNProperties properties;
        private boolean contentsChanged;
        private File contentsAbsPath;
        private SvnChecksum checksum;
        private String copyFromPath;
        private long copyFromRevision;
        private boolean unlock;

        private ChangeNode() {
        }
    }

    private static enum RestructureAction {
        RESTRUCTURE_NONE,
        RESTRUCTURE_ADD,
        RESTRUCTURE_ADD_ABSENT,
        RESTRUCTURE_DELETE;

    }
}

